/*
 * Decompiled with CFR 0.152.
 */
package jade.core.sam;

import jade.core.sam.AverageMeasure;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMInfo
implements Serializable {
    private static final long serialVersionUID = 84762938792387L;
    private Map<String, AverageMeasure> entityMeasures;
    private Map<String, Long> counterValues;

    SAMInfo() {
        this(new HashMap<String, AverageMeasure>(), new HashMap<String, Long>());
    }

    SAMInfo(Map<String, AverageMeasure> entityMeasures, Map<String, Long> counterValues) {
        this.entityMeasures = entityMeasures;
        this.counterValues = counterValues;
    }

    public Map<String, AverageMeasure> getEntityMeasures() {
        return this.entityMeasures;
    }

    public Map<String, Long> getCounterValues() {
        return this.counterValues;
    }

    void update(SAMInfo info) {
        Map<String, AverageMeasure> mm = info.getEntityMeasures();
        for (String entityName : mm.keySet()) {
            AverageMeasure newM = mm.get(entityName);
            AverageMeasure m = this.entityMeasures.get(entityName);
            if (m == null) {
                this.entityMeasures.put(entityName, newM);
                continue;
            }
            m.update(newM);
        }
        Map<String, Long> vv = info.getCounterValues();
        for (String counterName : vv.keySet()) {
            long newV = vv.get(counterName);
            Long v = this.counterValues.get(counterName);
            if (v == null) {
                this.counterValues.put(counterName, newV);
                continue;
            }
            this.counterValues.put(counterName, v + newV);
        }
    }
}

