/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.DummyAgent;

import jade.core.AID;
import jade.domain.FIPAAgentManagement.Envelope;
import jade.gui.AclGui;
import jade.gui.JadeLogoButton;
import jade.lang.acl.ACLCodec;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.StringACLCodec;
import jade.tools.DummyAgent.DummyAgent;
import jade.tools.DummyAgent.GuiProperties;
import jade.tools.DummyAgent.MsgIndication;
import jade.tools.DummyAgent.ToFromCellRenderer;
import jade.util.Logger;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

class DummyAgentGui
extends JFrame {
    DummyAgent myAgent;
    AID agentName;
    AclGui currentMsgGui;
    DefaultListModel queuedMsgListModel;
    JList queuedMsgList;
    File currentDir;
    String logoDummy = "images/dummyagent.gif";
    DummyAgentGui thisGUI;
    private Logger logger = Logger.getMyLogger(this.getClass().getName());

    DummyAgentGui(DummyAgent a) {
        this.thisGUI = this;
        this.myAgent = a;
        this.agentName = this.myAgent.getAID();
        this.currentDir = null;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                DummyAgentGui.this.myAgent.doDelete();
            }
        });
        try {
            this.setTitle(this.agentName.getName() + " - DummyAgent");
        }
        catch (Exception e) {
            this.setTitle("DummyAgent");
        }
        Image image = this.getToolkit().getImage(this.getClass().getResource(this.logoDummy));
        this.setIconImage(image);
        this.getContentPane().setLayout(new BorderLayout());
        this.queuedMsgListModel = new DefaultListModel();
        this.queuedMsgList = new JList(this.queuedMsgListModel);
        this.queuedMsgList.setCellRenderer(new ToFromCellRenderer());
        JScrollPane pane = new JScrollPane();
        pane.getViewport().setView(this.queuedMsgList);
        this.getContentPane().add("Center", pane);
        this.currentMsgGui = new AclGui(this);
        ACLMessage msg = new ACLMessage(0);
        msg.setSender(this.agentName);
        this.currentMsgGui.setMsg(msg);
        this.getContentPane().add("West", this.currentMsgGui);
        JMenuBar jmb = new JMenuBar();
        JMenu generalMenu = new JMenu("General");
        JMenuItem item = new JMenuItem("Exit");
        generalMenu.add(item);
        AbstractAction exitAction = new AbstractAction("Exit"){

            public void actionPerformed(ActionEvent e) {
                DummyAgentGui.this.myAgent.doDelete();
            }
        };
        item.addActionListener(exitAction);
        jmb.add(generalMenu);
        Icon resetImg = GuiProperties.getIcon("reset");
        Icon sendImg = GuiProperties.getIcon("send");
        Icon openImg = GuiProperties.getIcon("open");
        Icon saveImg = GuiProperties.getIcon("save");
        Icon openQImg = GuiProperties.getIcon("openq");
        Icon saveQImg = GuiProperties.getIcon("saveq");
        Icon setImg = GuiProperties.getIcon("set");
        Icon replyImg = GuiProperties.getIcon("reply");
        Icon viewImg = GuiProperties.getIcon("view");
        Icon deleteImg = GuiProperties.getIcon("delete");
        JMenu currentMsgMenu = new JMenu("Current message");
        item = new JMenuItem("Reset");
        currentMsgMenu.add(item);
        AbstractAction currentMessageAction = new AbstractAction("Current message", resetImg){

            public void actionPerformed(ActionEvent e) {
                ACLMessage m = new ACLMessage(0);
                m.setSender(DummyAgentGui.this.agentName);
                m.setEnvelope(new Envelope());
                DummyAgentGui.this.currentMsgGui.setMsg(m);
            }
        };
        item.addActionListener(currentMessageAction);
        item.setIcon(resetImg);
        item = new JMenuItem("Send");
        currentMsgMenu.add(item);
        AbstractAction sendAction = new AbstractAction("Send", sendImg){

            public void actionPerformed(ActionEvent e) {
                ACLMessage m = DummyAgentGui.this.currentMsgGui.getMsg();
                DummyAgentGui.this.queuedMsgListModel.add(0, new MsgIndication(m, 1, new Date()));
                StringACLCodec codec = new StringACLCodec();
                try {
                    String charset;
                    Envelope env = m.getEnvelope();
                    if (env == null || (charset = env.getPayloadEncoding()) == null) {
                        charset = "US-ASCII";
                    }
                    codec.decode(codec.encode(m, charset), charset);
                    DummyAgentGui.this.myAgent.send(m);
                }
                catch (ACLCodec.CodecException ce) {
                    if (DummyAgentGui.this.logger.isLoggable(Logger.WARNING)) {
                        DummyAgentGui.this.logger.log(Logger.WARNING, "Wrong ACL Message " + m.toString());
                    }
                    ce.printStackTrace();
                    JOptionPane.showMessageDialog(null, "Wrong ACL Message: \n" + ce.getMessage(), "Error Message", 0);
                }
            }
        };
        item.addActionListener(sendAction);
        item.setIcon(sendImg);
        item = new JMenuItem("Open");
        currentMsgMenu.add(item);
        AbstractAction openAction = new AbstractAction("Open", openImg){

            public void actionPerformed(ActionEvent e) {
                int returnVal;
                JFileChooser chooser = new JFileChooser();
                if (DummyAgentGui.this.currentDir != null) {
                    chooser.setCurrentDirectory(DummyAgentGui.this.currentDir);
                }
                if ((returnVal = chooser.showOpenDialog(null)) == 0) {
                    DummyAgentGui.this.currentDir = chooser.getCurrentDirectory();
                    String fileName = chooser.getSelectedFile().getAbsolutePath();
                    try {
                        StringACLCodec codec = new StringACLCodec(new FileReader(fileName), null);
                        DummyAgentGui.this.currentMsgGui.setMsg(codec.decode());
                    }
                    catch (FileNotFoundException e1) {
                        JOptionPane.showMessageDialog(null, "File not found: " + fileName + e1.getMessage(), "Error Message", 0);
                        if (DummyAgentGui.this.logger.isLoggable(Logger.WARNING)) {
                            DummyAgentGui.this.logger.log(Logger.WARNING, "File Not Found: " + fileName);
                        }
                    }
                    catch (ACLCodec.CodecException e2) {
                        if (DummyAgentGui.this.logger.isLoggable(Logger.WARNING)) {
                            DummyAgentGui.this.logger.log(Logger.WARNING, "Wrong ACL Message in file: " + fileName);
                        }
                        JOptionPane.showMessageDialog(null, "Wrong ACL Message in file: " + fileName + "\n" + e2.getMessage(), "Error Message", 0);
                    }
                }
            }
        };
        item.addActionListener(openAction);
        item.setIcon(openImg);
        item = new JMenuItem("Save");
        currentMsgMenu.add(item);
        AbstractAction saveAction = new AbstractAction("Save", saveImg){

            public void actionPerformed(ActionEvent e) {
                block6: {
                    int returnVal;
                    JFileChooser chooser = new JFileChooser();
                    if (DummyAgentGui.this.currentDir != null) {
                        chooser.setCurrentDirectory(DummyAgentGui.this.currentDir);
                    }
                    if ((returnVal = chooser.showSaveDialog(null)) == 0) {
                        DummyAgentGui.this.currentDir = chooser.getCurrentDirectory();
                        String fileName = chooser.getSelectedFile().getAbsolutePath();
                        try {
                            FileWriter f = new FileWriter(fileName);
                            StringACLCodec codec = new StringACLCodec(null, f);
                            ACLMessage ACLmsg = DummyAgentGui.this.currentMsgGui.getMsg();
                            codec.write(ACLmsg);
                            f.close();
                        }
                        catch (FileNotFoundException e3) {
                            if (DummyAgentGui.this.logger.isLoggable(Logger.WARNING)) {
                                DummyAgentGui.this.logger.log(Logger.WARNING, "Can't open file: " + fileName);
                            }
                        }
                        catch (IOException e4) {
                            if (!DummyAgentGui.this.logger.isLoggable(Logger.WARNING)) break block6;
                            DummyAgentGui.this.logger.log(Logger.WARNING, "IO Exception");
                        }
                    }
                }
            }
        };
        item.addActionListener(saveAction);
        item.setIcon(saveImg);
        currentMsgMenu.addSeparator();
        jmb.add(currentMsgMenu);
        JMenu queuedMsgMenu = new JMenu("Queued message");
        item = new JMenuItem("Open queue");
        queuedMsgMenu.add(item);
        AbstractAction openQAction = new AbstractAction("Open queue", openQImg){

            public void actionPerformed(ActionEvent e) {
                block11: {
                    int returnVal;
                    JFileChooser chooser = new JFileChooser();
                    if (DummyAgentGui.this.currentDir != null) {
                        chooser.setCurrentDirectory(DummyAgentGui.this.currentDir);
                    }
                    if ((returnVal = chooser.showOpenDialog(null)) == 0) {
                        for (int i = 0; i < DummyAgentGui.this.queuedMsgListModel.getSize(); ++i) {
                            DummyAgentGui.this.queuedMsgListModel.removeElementAt(i);
                        }
                        DummyAgentGui.this.currentDir = chooser.getCurrentDirectory();
                        String fileName = chooser.getSelectedFile().getAbsolutePath();
                        try {
                            int n;
                            BufferedReader inp;
                            block10: {
                                inp = new BufferedReader(new FileReader(fileName));
                                n = -1;
                                try {
                                    Integer nn = new Integer(inp.readLine());
                                    n = nn;
                                }
                                catch (IOException ioEx) {
                                    if (!DummyAgentGui.this.logger.isLoggable(Logger.WARNING)) break block10;
                                    DummyAgentGui.this.logger.log(Logger.WARNING, "IO Exception reading the number of messages in the queue");
                                }
                            }
                            for (int i = 0; i < n; ++i) {
                                MsgIndication mi = MsgIndication.fromText(inp);
                                DummyAgentGui.this.queuedMsgListModel.add(i, mi);
                            }
                        }
                        catch (FileNotFoundException e5) {
                            if (DummyAgentGui.this.logger.isLoggable(Logger.WARNING)) {
                                DummyAgentGui.this.logger.log(Logger.WARNING, "Can't open file: " + fileName);
                            }
                        }
                        catch (IOException e6) {
                            if (!DummyAgentGui.this.logger.isLoggable(Logger.WARNING)) break block11;
                            DummyAgentGui.this.logger.log(Logger.WARNING, "IO Exception");
                        }
                    }
                }
            }
        };
        item.addActionListener(openQAction);
        item.setIcon(openQImg);
        item = new JMenuItem("Save queue");
        queuedMsgMenu.add(item);
        AbstractAction saveQAction = new AbstractAction("Save queue", saveQImg){

            public void actionPerformed(ActionEvent e) {
                block10: {
                    int returnVal;
                    JFileChooser chooser = new JFileChooser();
                    if (DummyAgentGui.this.currentDir != null) {
                        chooser.setCurrentDirectory(DummyAgentGui.this.currentDir);
                    }
                    if ((returnVal = chooser.showSaveDialog(null)) == 0) {
                        DummyAgentGui.this.currentDir = chooser.getCurrentDirectory();
                        String fileName = chooser.getSelectedFile().getAbsolutePath();
                        try {
                            BufferedWriter out;
                            block9: {
                                out = new BufferedWriter(new FileWriter(fileName));
                                try {
                                    out.write(String.valueOf(DummyAgentGui.this.queuedMsgListModel.getSize()));
                                    out.newLine();
                                }
                                catch (IOException ioEx) {
                                    if (!DummyAgentGui.this.logger.isLoggable(Logger.WARNING)) break block9;
                                    DummyAgentGui.this.logger.log(Logger.WARNING, "IO Exception writing the number of messages in the queue");
                                }
                            }
                            for (int i = 0; i < DummyAgentGui.this.queuedMsgListModel.getSize(); ++i) {
                                MsgIndication mi = (MsgIndication)DummyAgentGui.this.queuedMsgListModel.get(i);
                                mi.toText(out);
                            }
                        }
                        catch (FileNotFoundException e5) {
                            if (DummyAgentGui.this.logger.isLoggable(Logger.WARNING)) {
                                DummyAgentGui.this.logger.log(Logger.WARNING, "Can't open file: " + fileName);
                            }
                        }
                        catch (IOException e6) {
                            if (!DummyAgentGui.this.logger.isLoggable(Logger.WARNING)) break block10;
                            DummyAgentGui.this.logger.log(Logger.WARNING, "IO Exception");
                        }
                    }
                }
            }
        };
        item.addActionListener(saveQAction);
        item.setIcon(saveQImg);
        item = new JMenuItem("Set as current");
        queuedMsgMenu.add(item);
        AbstractAction setAction = new AbstractAction("Set as current", setImg){

            public void actionPerformed(ActionEvent e) {
                int i = DummyAgentGui.this.queuedMsgList.getSelectedIndex();
                if (i != -1) {
                    MsgIndication mi = (MsgIndication)DummyAgentGui.this.queuedMsgListModel.getElementAt(i);
                    ACLMessage m = mi.getMessage();
                    DummyAgentGui.this.currentMsgGui.setMsg(m);
                }
            }
        };
        item.addActionListener(setAction);
        item.setIcon(setImg);
        item = new JMenuItem("Reply");
        queuedMsgMenu.add(item);
        AbstractAction replyAction = new AbstractAction("Reply", replyImg){

            public void actionPerformed(ActionEvent e) {
                int i = DummyAgentGui.this.queuedMsgList.getSelectedIndex();
                if (i != -1) {
                    MsgIndication mi = (MsgIndication)DummyAgentGui.this.queuedMsgListModel.getElementAt(i);
                    ACLMessage m = mi.getMessage();
                    ACLMessage reply = m.createReply();
                    reply.setEnvelope(new Envelope());
                    DummyAgentGui.this.currentMsgGui.setMsg(reply);
                }
            }
        };
        item.addActionListener(replyAction);
        item.setIcon(replyImg);
        item = new JMenuItem("View");
        queuedMsgMenu.add(item);
        AbstractAction viewAction = new AbstractAction("View", viewImg){

            public void actionPerformed(ActionEvent e) {
                int i = DummyAgentGui.this.queuedMsgList.getSelectedIndex();
                if (i != -1) {
                    MsgIndication mi = (MsgIndication)DummyAgentGui.this.queuedMsgListModel.getElementAt(i);
                    ACLMessage m = mi.getMessage();
                    AclGui.showMsgInDialog(m, DummyAgentGui.this.thisGUI);
                }
            }
        };
        item.addActionListener(viewAction);
        item.setIcon(viewImg);
        item = new JMenuItem("Delete");
        queuedMsgMenu.add(item);
        AbstractAction deleteAction = new AbstractAction("Delete", deleteImg){

            public void actionPerformed(ActionEvent e) {
                int i = DummyAgentGui.this.queuedMsgList.getSelectedIndex();
                if (i != -1) {
                    DummyAgentGui.this.queuedMsgListModel.removeElementAt(i);
                }
            }
        };
        item.addActionListener(deleteAction);
        item.setIcon(deleteImg);
        jmb.add(queuedMsgMenu);
        this.setJMenuBar(jmb);
        JToolBar bar = new JToolBar();
        JButton resetB = new JButton();
        resetB.setText("");
        resetB.setIcon(resetImg);
        resetB.setToolTipText("New the current ACL message");
        resetB.addActionListener(currentMessageAction);
        bar.add(resetB);
        JButton sendB = new JButton();
        sendB.setText("");
        sendB.setIcon(sendImg);
        sendB.setToolTipText("Send the current ACL message");
        sendB.addActionListener(sendAction);
        bar.add(sendB);
        JButton openB = new JButton();
        openB.setText("");
        openB.setIcon(openImg);
        openB.setToolTipText("Read the current ACL message from file");
        openB.addActionListener(openAction);
        bar.add(openB);
        JButton saveB = new JButton();
        saveB.setText("");
        saveB.setIcon(saveImg);
        saveB.setToolTipText("Save the current ACL message to file");
        saveB.addActionListener(saveAction);
        bar.add(saveB);
        bar.addSeparator(new Dimension(50, 30));
        JButton openQB = new JButton();
        openQB.setText("");
        openQB.setIcon(openQImg);
        openQB.setToolTipText("Read the queue of sent/received messages from file");
        openQB.addActionListener(openQAction);
        bar.add(openQB);
        JButton saveQB = new JButton();
        saveQB.setText("");
        saveQB.setIcon(saveQImg);
        saveQB.setToolTipText("Save the queue of sent/received messages to file");
        saveQB.addActionListener(saveQAction);
        bar.add(saveQB);
        bar.addSeparator();
        JButton setB = new JButton();
        setB.setText("");
        setB.setIcon(setImg);
        setB.setToolTipText("Set the selected ACL message to be the current message");
        setB.addActionListener(setAction);
        bar.add(setB);
        JButton replyB = new JButton();
        replyB.setText("");
        replyB.setIcon(replyImg);
        replyB.setToolTipText("Prepare a message to reply to the selected message");
        replyB.addActionListener(replyAction);
        bar.add(replyB);
        bar.addSeparator();
        JButton viewB = new JButton();
        viewB.setText("");
        viewB.setIcon(viewImg);
        viewB.setToolTipText("View the selected ACL message");
        viewB.addActionListener(viewAction);
        bar.add(viewB);
        JButton deleteB = new JButton();
        deleteB.setText("");
        deleteB.setIcon(deleteImg);
        deleteB.setToolTipText("Delete the selected ACL message");
        deleteB.addActionListener(deleteAction);
        bar.add(deleteB);
        bar.add(Box.createHorizontalGlue());
        JadeLogoButton logo = new JadeLogoButton();
        bar.add(logo);
        this.getContentPane().add("North", bar);
    }

    void showCorrect() {
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int centerX = (int)screenSize.getWidth() / 2;
        int centerY = (int)screenSize.getHeight() / 2;
        this.setLocation(centerX - this.getWidth() / 2, centerY - this.getHeight() / 2);
        this.setVisible(true);
    }
}

