/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.examples;

import bdi4jade.core.Capability;
import bdi4jade.core.MultipleCapabilityAgent;
import bdi4jade.core.SingleCapabilityAgent;
import bdi4jade.event.GoalEvent;
import bdi4jade.event.GoalListener;
import bdi4jade.examples.BDI4JADEExamplesAction;
import bdi4jade.examples.bdicycle.CompositeGoalCapability;
import bdi4jade.examples.bdicycle.PlanFailureCapability;
import bdi4jade.examples.bdicycle.SubgoalCapability;
import bdi4jade.examples.blocksworld.BlocksWorldCapability;
import bdi4jade.examples.blocksworld.BlocksWorldView;
import bdi4jade.examples.blocksworld.domain.On;
import bdi4jade.examples.blocksworld.domain.Thing;
import bdi4jade.examples.capabilities.Middle1Capability;
import bdi4jade.examples.capabilities.TopCapability;
import bdi4jade.examples.helloworld.HelloWorldAgent;
import bdi4jade.examples.helloworld.HelloWorldAnnotatedCapability;
import bdi4jade.examples.ping.PingPongCapability;
import bdi4jade.goal.BeliefValueGoal;
import bdi4jade.goal.CompositeGoal;
import bdi4jade.goal.Goal;
import bdi4jade.goal.ParallelGoal;
import bdi4jade.goal.SequentialGoal;
import jade.core.Agent;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class BDI4JADEExamplesPanel
extends JPanel {
    private static final long serialVersionUID = -1080267169700651610L;
    private final BDI4JADEExamplesAction[] actions = new BDI4JADEExamplesAction[]{new HelloWorldAction(), new HelloWorldAnnotatedAction(), new PingPongAction(), new CompositeGoalAction(), new PlanFailureAction(), new SubgoalCapabilityAction(), new MultiCapabilityAgentAction(), new BlocksWorldAction()};

    public BDI4JADEExamplesPanel() {
        this.setLayout(new GridLayout(this.actions.length, 1));
        BDI4JADEExamplesAction[] bDI4JADEExamplesActionArray = this.actions;
        int n = this.actions.length;
        int n2 = 0;
        while (n2 < n) {
            BDI4JADEExamplesAction action = bDI4JADEExamplesActionArray[n2];
            this.add(new JButton(action));
            ++n2;
        }
    }

    public Map<String, Agent> getAgents() {
        HashMap<String, Agent> agents = new HashMap<String, Agent>();
        BDI4JADEExamplesAction[] bDI4JADEExamplesActionArray = this.actions;
        int n = this.actions.length;
        int n2 = 0;
        while (n2 < n) {
            BDI4JADEExamplesAction action = bDI4JADEExamplesActionArray[n2];
            agents.putAll(action.getAgentMap());
            ++n2;
        }
        return agents;
    }

    private class BlocksWorldAction
    extends BDI4JADEExamplesAction
    implements GoalListener {
        private static final long serialVersionUID = 2100583035268414082L;
        private final SingleCapabilityAgent blocksWorldAgent;

        public BlocksWorldAction() {
            super.putValue("Name", "Blocks World");
            this.blocksWorldAgent = new SingleCapabilityAgent((Capability)new BlocksWorldCapability());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final JFrame frame = new JFrame();
            frame.setTitle((String)this.getValue("Name"));
            frame.setDefaultCloseOperation(2);
            frame.setVisible(false);
            frame.setContentPane(new BlocksWorldView(this.blocksWorldAgent.getCapability().getBeliefBase()));
            frame.pack();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    frame.setVisible(true);
                }
            });
            HashSet<On> target = new HashSet<On>();
            target.add(new On(Thing.BLOCK_5, Thing.TABLE));
            target.add(new On(Thing.BLOCK_4, Thing.BLOCK_5));
            target.add(new On(Thing.BLOCK_3, Thing.BLOCK_4));
            target.add(new On(Thing.BLOCK_2, Thing.BLOCK_3));
            target.add(new On(Thing.BLOCK_1, Thing.BLOCK_2));
            this.blocksWorldAgent.addGoal((Goal)new BeliefValueGoal((Object)"on", target), (GoalListener)this);
        }

        @Override
        public Set<Agent> getAgents() {
            HashSet<Agent> agents = new HashSet<Agent>();
            agents.add((Agent)this.blocksWorldAgent);
            return agents;
        }

        public void goalPerformed(GoalEvent event) {
            this.log.info((Object)"Goal achieved!!");
        }
    }

    private class CompositeGoalAction
    extends BDI4JADEExamplesAction
    implements GoalListener {
        private static final long serialVersionUID = 2100583035268414082L;
        private final SingleCapabilityAgent compositeGoalAgent;

        public CompositeGoalAction() {
            super.putValue("Name", "Composite Goal Agent");
            this.compositeGoalAgent = new SingleCapabilityAgent((Capability)new CompositeGoalCapability());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int answer = JOptionPane.showConfirmDialog(BDI4JADEExamplesPanel.this, "Should goals be achieved sequentially?", "Sequential vs. Parallel Goals", 0);
            Goal[] goals = new Goal[]{new CompositeGoalCapability.MyGoal1("Hello World!"), new CompositeGoalCapability.MyGoal2(), new CompositeGoalCapability.MyGoal3()};
            Object compositeGoal = null;
            compositeGoal = answer == 0 ? new SequentialGoal(goals) : new ParallelGoal(goals);
            this.compositeGoalAgent.addGoal((Goal)compositeGoal, (GoalListener)this);
        }

        @Override
        public Set<Agent> getAgents() {
            HashSet<Agent> agents = new HashSet<Agent>();
            agents.add((Agent)this.compositeGoalAgent);
            return agents;
        }

        public void goalPerformed(GoalEvent event) {
            if (event.getStatus().isFinished() && event.getGoal() instanceof CompositeGoal) {
                this.log.info((Object)"Goal finished!");
                this.log.info((Object)(event.getGoal() + " Status: " + event.getStatus()));
            }
        }
    }

    private class HelloWorldAction
    extends BDI4JADEExamplesAction {
        private static final long serialVersionUID = 2100583035268414082L;
        private final HelloWorldAgent helloWorldAgent;

        public HelloWorldAction() {
            super.putValue("Name", "Hello World Agent");
            this.helloWorldAgent = new HelloWorldAgent();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String name = JOptionPane.showInputDialog(BDI4JADEExamplesPanel.this, (Object)"Please, inform your name:");
            this.helloWorldAgent.addGoal(new HelloWorldAgent.HelloWorldGoal(name));
        }

        @Override
        public Set<Agent> getAgents() {
            HashSet<Agent> agents = new HashSet<Agent>();
            agents.add((Agent)this.helloWorldAgent);
            return agents;
        }
    }

    private class HelloWorldAnnotatedAction
    extends BDI4JADEExamplesAction
    implements GoalListener {
        private static final long serialVersionUID = 2100583035268414082L;
        private final SingleCapabilityAgent helloWorldAnnotatedAgent;

        public HelloWorldAnnotatedAction() {
            super.putValue("Name", "Hello World Annotated Capability");
            this.helloWorldAnnotatedAgent = new SingleCapabilityAgent((Capability)new HelloWorldAnnotatedCapability());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String name = JOptionPane.showInputDialog(BDI4JADEExamplesPanel.this, (Object)"Please, inform your name:");
            this.helloWorldAnnotatedAgent.addGoal((Goal)new HelloWorldAnnotatedCapability.HelloWorldGoal(name), (GoalListener)this);
        }

        @Override
        public Set<Agent> getAgents() {
            HashSet<Agent> agents = new HashSet<Agent>();
            agents.add((Agent)this.helloWorldAnnotatedAgent);
            return agents;
        }

        public void goalPerformed(GoalEvent event) {
            if (event.getStatus().isFinished()) {
                System.out.println("Hello World Goal Finished! Time: " + event.getGoal());
            }
        }
    }

    private class MultiCapabilityAgentAction
    extends BDI4JADEExamplesAction {
        private static final long serialVersionUID = 2100583035268414082L;
        private final MultipleCapabilityAgent multiCapabilityAgent;

        public MultiCapabilityAgentAction() {
            super.putValue("Name", "Multi-capability Agent");
            this.multiCapabilityAgent = new MultipleCapabilityAgent((Capability)new TopCapability());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.multiCapabilityAgent.addGoal((Goal)new Middle1Capability.TestGoal());
        }

        @Override
        public Set<Agent> getAgents() {
            HashSet<Agent> agents = new HashSet<Agent>();
            agents.add((Agent)this.multiCapabilityAgent);
            return agents;
        }
    }

    private class PingPongAction
    extends BDI4JADEExamplesAction {
        public static final String AGENT_1 = "Alice";
        public static final String AGENT_2 = "Bob";
        private static final long serialVersionUID = 2100583035268414082L;
        private final SingleCapabilityAgent agent1;
        private final SingleCapabilityAgent agent2;

        public PingPongAction() {
            super.putValue("Name", "Ping Pong Agents");
            this.agent1 = new SingleCapabilityAgent((Capability)new PingPongCapability(AGENT_2, 2));
            this.agent2 = new SingleCapabilityAgent((Capability)new PingPongCapability(AGENT_1, 1));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.agent1.addGoal((Goal)new PingPongCapability.PingGoal());
            this.agent2.addGoal((Goal)new PingPongCapability.PingGoal());
        }

        @Override
        public Map<String, Agent> getAgentMap() {
            HashMap<String, Agent> agentMap = new HashMap<String, Agent>();
            agentMap.put(AGENT_1, (Agent)this.agent1);
            agentMap.put(AGENT_2, (Agent)this.agent2);
            return agentMap;
        }

        @Override
        public Set<Agent> getAgents() {
            return new HashSet<Agent>(this.getAgentMap().values());
        }
    }

    private class PlanFailureAction
    extends BDI4JADEExamplesAction
    implements GoalListener {
        private static final int GOALS = 10;
        private static final long serialVersionUID = 2100583035268414082L;
        private int counter;
        private final SingleCapabilityAgent planFailureAgent;

        public PlanFailureAction() {
            super.putValue("Name", "Plan Failure Agent");
            this.planFailureAgent = new SingleCapabilityAgent((Capability)new PlanFailureCapability());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int goalsNum = 10;
            try {
                goalsNum = new Integer(JOptionPane.showInputDialog(BDI4JADEExamplesPanel.this, (Object)"Please, inform the number of goals to be dispatched:"));
            }
            catch (Exception exc) {
                this.log.warn((Object)exc);
                this.log.warn((Object)"Using default number of goals: 10");
            }
            this.counter = 0;
            int i = 0;
            while (i < goalsNum) {
                this.planFailureAgent.addGoal((Goal)new PlanFailureCapability.MyGoal(i), (GoalListener)this);
                ++i;
            }
        }

        @Override
        public Set<Agent> getAgents() {
            HashSet<Agent> agents = new HashSet<Agent>();
            agents.add((Agent)this.planFailureAgent);
            return agents;
        }

        public void goalPerformed(GoalEvent event) {
            if (event.getStatus().isFinished() && event.getGoal() instanceof PlanFailureCapability.MyGoal) {
                this.log.info((Object)(event.getGoal() + " Status: " + event.getStatus()));
                ++this.counter;
                if (this.counter >= 10) {
                    this.log.info((Object)"Goal finished!!");
                }
            }
        }
    }

    private class SubgoalCapabilityAction
    extends BDI4JADEExamplesAction {
        private static final long serialVersionUID = 2100583035268414082L;
        private final SingleCapabilityAgent subgoalCapability;

        public SubgoalCapabilityAction() {
            super.putValue("Name", "Subgoal Goal Agent");
            this.subgoalCapability = new SingleCapabilityAgent((Capability)new SubgoalCapability());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.subgoalCapability.addGoal((Goal)new SubgoalCapability.ParentGoal());
        }

        @Override
        public Set<Agent> getAgents() {
            HashSet<Agent> agents = new HashSet<Agent>();
            agents.add((Agent)this.subgoalCapability);
            return agents;
        }
    }
}

