/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.examples.bdicycle;

import bdi4jade.annotation.GoalOwner;
import bdi4jade.annotation.Parameter;
import bdi4jade.annotation.Plan;
import bdi4jade.core.Capability;
import bdi4jade.goal.Goal;
import bdi4jade.goal.GoalTemplateFactory;
import bdi4jade.plan.DefaultPlan;
import bdi4jade.plan.Plan;
import bdi4jade.plan.planbody.AbstractPlanBody;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompositeGoalCapability
extends Capability {
    private static final Log log = LogFactory.getLog(CompositeGoalCapability.class);
    private static final long serialVersionUID = -4800805796961540570L;
    @Plan
    private DefaultPlan multigoalPlan1 = new DefaultPlan("multigoalPlan1", MyPlan.class);
    @Plan
    private DefaultPlan multigoalPlan2;

    public CompositeGoalCapability() {
        this.multigoalPlan1.addGoalTemplate(GoalTemplateFactory.goalOfType(MyGoal1.class));
        this.multigoalPlan1.addGoalTemplate(GoalTemplateFactory.goalOfType(MyGoal2.class));
        this.multigoalPlan2 = new DefaultPlan("multigoalPlan2", MyPlan.class);
        this.multigoalPlan2.addGoalTemplate(GoalTemplateFactory.goalOfType(MyGoal2.class));
        this.multigoalPlan2.addGoalTemplate(GoalTemplateFactory.goalOfType(MyGoal3.class));
    }

    @GoalOwner(capability=CompositeGoalCapability.class)
    public static class MyGoal1
    implements Goal {
        private static final long serialVersionUID = 3405041038738876061L;
        private String msg;

        public MyGoal1(String msg) {
            this.msg = msg;
        }

        @Parameter(direction=Parameter.Direction.OUT)
        public String getMsg() {
            return this.msg;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + ": " + this.msg;
        }
    }

    @GoalOwner(capability=CompositeGoalCapability.class)
    public static class MyGoal2
    implements Goal {
        private static final long serialVersionUID = 3405041038738876061L;
        private String message;

        @Parameter(direction=Parameter.Direction.INOUT)
        public String getMsg() {
            return this.message;
        }

        public void setMsg(String msg) {
            this.message = msg;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + ": " + this.message;
        }
    }

    @GoalOwner(capability=CompositeGoalCapability.class)
    public static class MyGoal3
    implements Goal {
        private static final long serialVersionUID = 3405041038738876061L;
        private String msg;

        @Parameter(direction=Parameter.Direction.IN)
        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + ": " + this.msg;
        }
    }

    public static class MyPlan
    extends AbstractPlanBody {
        private static final long serialVersionUID = -220345270457161508L;

        public void action() {
            long random = new Random().nextLong();
            log.info((Object)("Random: " + random));
            if (random % 7L != 0L) {
                this.setEndState(Plan.EndState.SUCCESSFUL);
            } else {
                this.setEndState(Plan.EndState.FAILED);
            }
            log.info((Object)(this.getGoal() + " Plan#" + this.getPlan().getId() + " EndState: " + this.getEndState()));
        }
    }
}

