/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.examples.bdicycle;

import bdi4jade.annotation.GoalOwner;
import bdi4jade.annotation.Plan;
import bdi4jade.core.Capability;
import bdi4jade.goal.Goal;
import bdi4jade.plan.DefaultPlan;
import bdi4jade.plan.Plan;
import bdi4jade.plan.planbody.AbstractPlanBody;
import bdi4jade.plan.planbody.DisposablePlanBody;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SubgoalCapability
extends Capability {
    private static final Log log = LogFactory.getLog(SubgoalCapability.class);
    private static final long serialVersionUID = -4388902481688697669L;
    @Plan
    private bdi4jade.plan.Plan childPlan = new DefaultPlan(Subgoal.class, ChildPlan.class);
    @Plan
    private bdi4jade.plan.Plan myPlan = new DefaultPlan(TopLevelGoal.class, MyPlan.class);
    @Plan
    private bdi4jade.plan.Plan parentPlan = new DefaultPlan(ParentGoal.class, ParentPlan.class);

    public static class ChildPlan
    extends AbstractPlanBody
    implements DisposablePlanBody {
        private static final long serialVersionUID = -5432560989511973914L;
        private int counter;

        public void action() {
            if (this.counter == 0) {
                this.dispatchSubgoal(new Subgoal());
            }
            log.info((Object)("ChildPlan executing... counter " + this.counter));
            ++this.counter;
        }

        public void onAbort() {
            log.info((Object)"ChildPlan aborted.");
        }

        public void onStart() {
            this.counter = 0;
        }
    }

    public static class MyPlan
    extends AbstractPlanBody {
        private static final long serialVersionUID = -5432560989511973914L;
        private int counter;

        public void action() {
            log.info((Object)("Plan executing... counter " + this.counter));
            ++this.counter;
            if (this.counter >= 5) {
                log.info((Object)("Plan " + this.getPlan().getId() + " completed its execution."));
                this.setEndState(Plan.EndState.SUCCESSFUL);
            }
        }

        public void onStart() {
            this.counter = 0;
        }
    }

    @GoalOwner(capability=SubgoalCapability.class, internal=false)
    public static class ParentGoal
    implements Goal {
        private static final long serialVersionUID = 2702962164032833240L;
    }

    public static class ParentPlan
    extends AbstractPlanBody {
        private static final long serialVersionUID = -5432560989511973914L;
        private int counter;

        public void action() {
            if (this.counter == 0) {
                this.dispatchGoal(new TopLevelGoal());
                this.dispatchSubgoal(new Subgoal());
            }
            log.info((Object)("ParentPlan executing... counter " + this.counter));
            ++this.counter;
            if (this.counter >= 5) {
                this.setEndState(Plan.EndState.FAILED);
                log.info((Object)"Finishing ParentPlan.");
            }
        }

        public int onEnd() {
            log.info((Object)"ParentPlan ended.");
            return super.onEnd();
        }

        public void onStart() {
            this.counter = 0;
        }
    }

    @GoalOwner(capability=SubgoalCapability.class, internal=true)
    public static class Subgoal
    implements Goal {
        private static final long serialVersionUID = 2330672980228870224L;
    }

    @GoalOwner(capability=SubgoalCapability.class, internal=false)
    public static class TopLevelGoal
    implements Goal {
        private static final long serialVersionUID = 2702962164032833240L;
    }
}

