/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.extension.planselection.utilitybased;

import bdi4jade.extension.planselection.utilitybased.PlanContribution;
import bdi4jade.extension.planselection.utilitybased.SoftgoalPreferences;
import bdi4jade.goal.Goal;
import bdi4jade.goal.Softgoal;
import bdi4jade.plan.Plan;
import bdi4jade.reasoning.AbstractReasoningStrategy;
import bdi4jade.reasoning.PlanSelectionStrategy;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UtilityBasedPlanSelectionStrategy
extends AbstractReasoningStrategy
implements PlanSelectionStrategy {
    private static final Log log = LogFactory.getLog(UtilityBasedPlanSelectionStrategy.class);

    private double calculateExpectedUtility(Plan plan, Softgoal softgoal) {
        List contributions = (List)((Map)plan.getMetadata((Object)PlanContribution.METADATA_NAME)).get(softgoal);
        double expectedUtility = 0.0;
        if (contributions != null) {
            for (PlanContribution contribution : contributions) {
                expectedUtility += contribution.getProbability() * contribution.getValue();
            }
        }
        return expectedUtility;
    }

    public Plan selectPlan(Goal goal, Set<Plan> plans) {
        Plan selectedPlan = null;
        Double maxUtility = null;
        for (Plan plan : plans) {
            double utility = 0.0;
            SoftgoalPreferences preferences = (SoftgoalPreferences)plan.getPlanLibrary().getCapability().getBeliefBase().getBelief((Object)"SoftgoalPreferences");
            for (Softgoal softgoal : this.capability.getMyAgent().getSoftgoals()) {
                Double preference = preferences.getPreferenceForSoftgoal(softgoal);
                if (preference == null) continue;
                double expectedUtility = this.calculateExpectedUtility(plan, softgoal);
                utility += preference * expectedUtility;
            }
            log.debug((Object)("EU[" + plan.getId() + "] = " + utility));
            if (selectedPlan != null && !(maxUtility < utility)) continue;
            selectedPlan = plan;
            maxUtility = utility;
        }
        return selectedPlan;
    }
}

