/*
 * Decompiled with CFR 0.152.
 */
package jade.content.abs;

import jade.content.ContentElement;
import jade.content.ContentElementList;
import jade.content.OntoACLMessage;
import jade.content.OntoAID;
import jade.content.abs.AbsAgentAction;
import jade.content.abs.AbsAggregate;
import jade.content.abs.AbsConcept;
import jade.content.abs.AbsContentElement;
import jade.content.abs.AbsContentElementList;
import jade.content.abs.AbsIRE;
import jade.content.abs.AbsObject;
import jade.content.abs.AbsPredicate;
import jade.content.abs.AbsPrimitive;
import jade.content.abs.AbsTerm;
import jade.content.abs.AbsVariable;
import jade.content.onto.AggregateHelper;
import jade.content.onto.BasicOntology;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.schema.AggregateSchema;
import jade.content.schema.ObjectSchema;
import jade.content.schema.PrimitiveSchema;
import jade.content.schema.TermSchema;
import jade.core.AID;
import jade.core.CaseInsensitiveString;
import jade.lang.acl.ACLMessage;
import jade.util.leap.ArrayList;
import jade.util.leap.HashSet;
import jade.util.leap.List;
import jade.util.leap.Set;
import java.util.Collection;
import java.util.Iterator;

public class AbsHelper {
    public static AbsAggregate externaliseList(List obj, Ontology onto, String AggregateType) throws OntologyException {
        AbsAggregate ret = new AbsAggregate(AggregateType);
        try {
            for (int i = 0; i < obj.size(); ++i) {
                ret.add((AbsTerm)onto.fromObject(obj.get(i)));
            }
        }
        catch (ClassCastException cce) {
            throw new OntologyException("Non term object in aggregate");
        }
        return ret;
    }

    public static AbsAggregate externaliseSet(Set obj, Ontology onto, String AggregateType) throws OntologyException {
        AbsAggregate ret = new AbsAggregate(AggregateType);
        try {
            jade.util.leap.Iterator it = obj.iterator();
            while (it.hasNext()) {
                ret.add((AbsTerm)onto.fromObject(it.next()));
            }
        }
        catch (ClassCastException cce) {
            throw new OntologyException("Non term object in aggregate");
        }
        return ret;
    }

    public static AbsAggregate externaliseIterator(Iterator obj, Ontology onto, String AggregateType) throws OntologyException {
        AbsAggregate ret = new AbsAggregate(AggregateType);
        try {
            while (obj.hasNext()) {
                ret.add((AbsTerm)onto.fromObject(obj.next()));
            }
        }
        catch (ClassCastException cce) {
            throw new OntologyException("Non term object in aggregate");
        }
        return ret;
    }

    public static AbsConcept externaliseAID(AID obj) {
        AbsConcept aid = new AbsConcept("agent-identifier");
        aid.set("name", obj.getName());
        jade.util.leap.Iterator i = obj.getAllAddresses();
        if (i.hasNext()) {
            AbsAggregate addresses = new AbsAggregate("sequence");
            while (i.hasNext()) {
                String addr = (String)i.next();
                addresses.add(AbsPrimitive.wrap(addr));
            }
            aid.set("addresses", addresses);
        }
        if ((i = obj.getAllResolvers()).hasNext()) {
            AbsAggregate resolvers = new AbsAggregate("sequence");
            while (i.hasNext()) {
                AID res = (AID)i.next();
                resolvers.add(AbsHelper.externaliseAID(res));
            }
            aid.set("resolvers", resolvers);
        }
        return aid;
    }

    public static AbsContentElementList externaliseContentElementList(ContentElementList obj, Ontology onto) throws OntologyException {
        AbsContentElementList ret = new AbsContentElementList();
        try {
            for (int i = 0; i < obj.size(); ++i) {
                ret.add((AbsContentElement)onto.fromObject(obj.get(i)));
            }
        }
        catch (ClassCastException cce) {
            throw new OntologyException("Non content element object in content element list");
        }
        return ret;
    }

    public static AbsAgentAction externaliseACLMessage(ACLMessage obj, Ontology onto) throws OntologyException {
        try {
            AbsAgentAction absMsg = new AbsAgentAction(ACLMessage.getPerformative(obj.getPerformative()));
            absMsg.set("sender", (AbsTerm)onto.fromObject(obj.getSender()));
            AbsAggregate recvs = new AbsAggregate("sequence");
            jade.util.leap.Iterator it = obj.getAllReceiver();
            while (it.hasNext()) {
                recvs.add((AbsTerm)onto.fromObject(it.next()));
            }
            if (recvs.size() > 0) {
                absMsg.set("receivers", recvs);
            }
            AbsAggregate repls = new AbsAggregate("sequence");
            it = obj.getAllReplyTo();
            while (it.hasNext()) {
                repls.add((AbsTerm)onto.fromObject(it.next()));
            }
            if (repls.size() > 0) {
                absMsg.set("reply-to", repls);
            }
            absMsg.set("language", obj.getLanguage());
            absMsg.set("ontology", obj.getOntology());
            absMsg.set("protocol", obj.getProtocol());
            absMsg.set("in-reply-to", obj.getInReplyTo());
            absMsg.set("reply-with", obj.getReplyWith());
            absMsg.set("conversation-id", obj.getConversationId());
            absMsg.set("reply-by", obj.getReplyByDate());
            if (obj.hasByteSequenceContent()) {
                absMsg.set("bs-content", obj.getByteSequenceContent());
            } else {
                absMsg.set("content", obj.getContent());
            }
            absMsg.set("encoding", obj.getEncoding());
            return absMsg;
        }
        catch (Exception e) {
            throw new OntologyException("Error externalising ACLMessage", e);
        }
    }

    public static List internaliseList(AbsAggregate aggregate, Ontology onto) throws OntologyException {
        ArrayList ret = new ArrayList();
        for (int i = 0; i < aggregate.size(); ++i) {
            Object element = onto.toObject(aggregate.get(i));
            Ontology.checkIsTerm(element);
            ret.add(element);
        }
        return ret;
    }

    public static Set internaliseSet(AbsAggregate aggregate, Ontology onto) throws OntologyException {
        HashSet ret = new HashSet();
        for (int i = 0; i < aggregate.size(); ++i) {
            Object element = onto.toObject(aggregate.get(i));
            Ontology.checkIsTerm(element);
            ret.add(element);
        }
        return ret;
    }

    public static Collection internaliseJavaCollection(AbsAggregate aggregate, Ontology onto) throws OntologyException {
        Collection collection;
        try {
            collection = (Collection)Class.forName(aggregate.getTypeName()).newInstance();
        }
        catch (Exception e) {
            throw new OntologyException("Cannot instantiate java collection of class " + aggregate.getTypeName(), e);
        }
        for (int i = 0; i < aggregate.size(); ++i) {
            Object element = onto.toObject(aggregate.get(i));
            Ontology.checkIsTerm(element);
            collection.add(element);
        }
        return collection;
    }

    public static OntoAID internaliseAID(AbsConcept aid) throws OntologyException {
        OntoAID ret = new OntoAID();
        try {
            AbsAggregate resolvers;
            ret.setName(aid.getString("name"));
            AbsAggregate addresses = (AbsAggregate)aid.getAbsObject("addresses");
            if (addresses != null) {
                for (int i = 0; i < addresses.size(); ++i) {
                    String addr = ((AbsPrimitive)addresses.get(i)).getString();
                    ret.addAddresses(addr);
                }
            }
            if ((resolvers = (AbsAggregate)aid.getAbsObject("resolvers")) != null) {
                for (int i = 0; i < resolvers.size(); ++i) {
                    OntoAID res = AbsHelper.internaliseAID((AbsConcept)resolvers.get(i));
                    ret.addResolvers(res);
                }
            }
            return ret;
        }
        catch (Exception e) {
            throw new OntologyException(aid + " is not a valid AID");
        }
    }

    public static ContentElementList internaliseContentElementList(AbsContentElementList l, Ontology onto) throws OntologyException {
        ContentElementList ret = new ContentElementList();
        try {
            for (int i = 0; i < l.size(); ++i) {
                ContentElement element = (ContentElement)onto.toObject(l.get(i));
                ret.add(element);
            }
        }
        catch (ClassCastException cce) {
            throw new OntologyException("Non content element object in content element list");
        }
        return ret;
    }

    public static OntoACLMessage internaliseACLMessage(AbsAgentAction absMsg, Ontology onto) throws OntologyException {
        OntoACLMessage ret = new OntoACLMessage(ACLMessage.getInteger(absMsg.getTypeName()));
        try {
            jade.util.leap.Iterator it;
            ret.setSender((AID)onto.toObject(absMsg.getAbsObject("sender")));
            ret.clearAllReceiver();
            List l = (List)onto.toObject(absMsg.getAbsObject("receivers"));
            if (l != null) {
                it = l.iterator();
                while (it.hasNext()) {
                    ret.addReceiver((AID)it.next());
                }
            }
            ret.clearAllReplyTo();
            l = (List)onto.toObject(absMsg.getAbsObject("reply-to"));
            if (l != null) {
                it = l.iterator();
                while (it.hasNext()) {
                    ret.addReplyTo((AID)it.next());
                }
            }
            ret.setLanguage(absMsg.getString("language"));
            ret.setOntology(absMsg.getString("ontology"));
            ret.setProtocol(absMsg.getString("protocol"));
            ret.setInReplyTo(absMsg.getString("in-reply-to"));
            ret.setReplyWith(absMsg.getString("reply-with"));
            ret.setConversationId(absMsg.getString("conversation-id"));
            ret.setReplyByDate(absMsg.getDate("reply-by"));
            String c = absMsg.getString("content");
            if (c != null) {
                ret.setContent(c);
            } else {
                byte[] bsc = absMsg.getByteSequence("bs-content");
                if (bsc != null) {
                    ret.setByteSequenceContent(bsc);
                }
            }
            ret.setEncoding(absMsg.getString("encoding"));
            return ret;
        }
        catch (Exception e) {
            throw new OntologyException("Error internalising OntoACLMessage", e);
        }
    }

    public static void setAttribute(AbsObject abs, String attrName, AbsObject attrValue) throws OntologyException {
        if (abs.getAbsType() == 3) {
            if (attrValue instanceof AbsTerm || attrValue == null) {
                ((AbsAgentAction)abs).set(attrName, (AbsTerm)attrValue);
                return;
            }
            if (attrValue instanceof AbsPredicate || attrValue == null) {
                ((AbsAgentAction)abs).set(attrName, (AbsPredicate)attrValue);
                return;
            }
        }
        if (abs.getAbsType() == 2) {
            if (attrValue instanceof AbsTerm || attrValue == null) {
                ((AbsConcept)abs).set(attrName, (AbsTerm)attrValue);
                return;
            }
        } else {
            if (abs.getAbsType() == 1) {
                ((AbsPredicate)abs).set(attrName, attrValue);
                return;
            }
            if (abs.getAbsType() == 6) {
                if (attrValue instanceof AbsVariable && CaseInsensitiveString.equalsIgnoreCase(attrName, "Variable")) {
                    ((AbsIRE)abs).setVariable((AbsVariable)attrValue);
                    return;
                }
                if (attrValue instanceof AbsPredicate && CaseInsensitiveString.equalsIgnoreCase(attrName, "Proposition")) {
                    ((AbsIRE)abs).setProposition((AbsPredicate)attrValue);
                    return;
                }
            } else if (abs.getAbsType() == 7) {
                if (attrValue instanceof AbsPrimitive && CaseInsensitiveString.equalsIgnoreCase(attrName, "Name")) {
                    ((AbsVariable)abs).setName(((AbsPrimitive)attrValue).getString());
                    return;
                }
                if (attrValue instanceof AbsPrimitive && CaseInsensitiveString.equalsIgnoreCase(attrName, "ValueType")) {
                    ((AbsVariable)abs).setType(((AbsPrimitive)attrValue).getString());
                    return;
                }
            }
        }
        throw new OntologyException("Type incompatibility: value of attribute " + attrName + " of " + abs + " is " + attrValue);
    }

    public static AbsObject nullifyVariables(AbsObject abs, boolean removeEmptyAggregate) {
        AbsAggregate absAggregate;
        if (abs instanceof AbsVariable) {
            return null;
        }
        if (removeEmptyAggregate && abs instanceof AbsAggregate && (absAggregate = (AbsAggregate)abs).size() == 0) {
            return null;
        }
        if (!abs.isGrounded()) {
            if (abs instanceof AbsAggregate) {
                absAggregate = (AbsAggregate)abs;
                jade.util.leap.Iterator it = absAggregate.iterator();
                while (it.hasNext()) {
                    AbsObject slotValue = (AbsObject)it.next();
                    AbsObject nullifiedSlotValue = AbsHelper.nullifyVariables(slotValue, removeEmptyAggregate);
                    if (nullifiedSlotValue != null) continue;
                    it.remove();
                }
                if (removeEmptyAggregate && abs.getCount() == 0) {
                    return null;
                }
            } else {
                for (String slotName : abs.getNames()) {
                    AbsObject slotValue = abs.getAbsObject(slotName);
                    AbsObject nullifiedSlotValue = AbsHelper.nullifyVariables(slotValue, removeEmptyAggregate);
                    ((AbsConcept)abs).set(slotName, nullifiedSlotValue);
                }
            }
        }
        return abs;
    }

    public static AbsObject removePrefix(AbsObject abs, String separator) throws OntologyException {
        if (abs instanceof AbsConcept || abs instanceof AbsAggregate) {
            int separatorPos;
            String typeName = abs.getTypeName();
            if (BasicOntology.getInstance().getSchema(typeName) == null && (separatorPos = typeName.lastIndexOf(separator)) != -1 && separatorPos < typeName.length()) {
                typeName = typeName.substring(separatorPos + separator.length());
                ((AbsConcept)abs).setTypeName(typeName);
            }
            for (String slotName : abs.getNames()) {
                AbsHelper.removePrefix(abs.getAbsObject(slotName), separator);
            }
        }
        return abs;
    }

    public static AbsObject addPrefix(AbsObject abs, String prefix) throws OntologyException {
        if (abs instanceof AbsConcept || abs instanceof AbsAggregate) {
            String typeName = abs.getTypeName();
            if (BasicOntology.getInstance().getSchema(typeName) == null) {
                ((AbsConcept)abs).setTypeName(prefix + typeName);
            }
            for (String slotName : abs.getNames()) {
                AbsHelper.addPrefix(abs.getAbsObject(slotName), prefix);
            }
        }
        return abs;
    }

    public static boolean isAbsTemplate(AbsObject abs) {
        if (abs instanceof AbsPrimitive) {
            return false;
        }
        if (abs instanceof AbsAggregate) {
            jade.util.leap.Iterator it = ((AbsAggregate)abs).iterator();
            while (it.hasNext()) {
                if (AbsHelper.isAbsTemplate((AbsObject)it.next())) continue;
                return false;
            }
        }
        if (abs instanceof AbsConcept) {
            for (String slotName : abs.getNames()) {
                if (AbsHelper.isAbsTemplate(abs.getAbsObject(slotName))) continue;
                return false;
            }
        }
        return true;
    }

    public static AbsObject applyDefaultValues(AbsObject absTemplate, AbsObject absDefault) throws OntologyException {
        if (absTemplate instanceof AbsAggregate && absTemplate.getCount() != 0 && absTemplate.isGrounded()) {
            return absTemplate;
        }
        if (!(absTemplate instanceof AbsAggregate) && absTemplate.isGrounded()) {
            return absTemplate;
        }
        if (absTemplate == null || absTemplate instanceof AbsVariable) {
            return absDefault;
        }
        if (absDefault == null) {
            if (AbsHelper.isAbsTemplate(absTemplate)) {
                return null;
            }
            return absTemplate;
        }
        if (!(absDefault instanceof AbsConcept)) {
            throw new OntologyException("Default abs structure (" + absDefault.getAbsType() + ") not compatible with template (" + absTemplate.getAbsType() + ")");
        }
        for (String slotName : absTemplate.getNames()) {
            AbsObject slotTemplateValue = absTemplate.getAbsObject(slotName);
            AbsObject absDefaultValue = absDefault.getAbsObject(slotName);
            if (absDefaultValue == null) continue;
            AbsHelper.setAttribute(absTemplate, slotName, AbsHelper.applyDefaultValues(slotTemplateValue, absDefaultValue));
        }
        return absTemplate;
    }

    public static AbsObject createAbsTemplate(Class clazz, Ontology onto) throws OntologyException {
        ObjectSchema schema = onto.getSchema(clazz);
        if (schema == null) {
            schema = AggregateHelper.getSchema(clazz, null);
        }
        return AbsHelper.createAbsTemplate(schema, null, VarIndexWrapper.ZERO);
    }

    public static AbsObject createAbsTemplate(ObjectSchema schema) throws OntologyException {
        return AbsHelper.createAbsTemplate(schema, null, VarIndexWrapper.ZERO);
    }

    public static AbsObject createAbsTemplate(ObjectSchema schema, String prefix) throws OntologyException {
        return AbsHelper.createAbsTemplate(schema, prefix, VarIndexWrapper.ZERO);
    }

    private static AbsObject createAbsTemplate(ObjectSchema schema, String prefix, VarIndexWrapper viw) throws OntologyException {
        if (schema instanceof PrimitiveSchema || schema.getClass() == TermSchema.class) {
            return new AbsVariable(AbsHelper.createVariableName(prefix, viw), schema.getTypeName());
        }
        if (schema instanceof AggregateSchema) {
            AggregateSchema aggregateSchema = (AggregateSchema)schema;
            AbsAggregate aggregate = new AbsAggregate(aggregateSchema.getTypeName());
            TermSchema elementsSchema = aggregateSchema.getElementsSchema();
            if (elementsSchema != null) {
                aggregate.setElementTemplate((AbsTerm)AbsHelper.createAbsTemplate(elementsSchema, prefix, viw));
            }
            return aggregate;
        }
        AbsObject abs = schema.newInstance();
        for (String slotName : schema.getNames()) {
            ObjectSchema slotSchema = schema.getSchema(slotName);
            AbsHelper.setAttribute(abs, slotName, AbsHelper.createAbsTemplate(slotSchema, prefix, viw));
        }
        return abs;
    }

    private static String createVariableName(String prefix, VarIndexWrapper viw) {
        String varName = (prefix != null ? prefix : "") + "v#" + viw.index;
        ++viw.index;
        return varName;
    }

    static class VarIndexWrapper {
        static VarIndexWrapper ZERO = new VarIndexWrapper(0);
        int index;

        public VarIndexWrapper(int index) {
            this.index = index;
        }
    }
}

