/*
 * Decompiled with CFR 0.152.
 */
package jade.mtp.http;

import jade.core.Profile;
import jade.mtp.MTPException;
import jade.mtp.http.HTTPAddress;
import jade.mtp.http.https.HTTPSKeyManager;
import jade.mtp.http.https.HTTPSTrustManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.TrustManager;

public class HTTPSocketFactory {
    private static HTTPSocketFactory _instance;
    private static final String PREFIX = "jade_mtp_http_https_";
    private static final String MTP_HTTP_PREFIX = "jade_mtp_http_";
    private static final int DEFAULT_CONNECT_TIMEOUT = -1;
    private SocketFactory _socketFactory;
    private ServerSocketFactory _serverSocketFactory;
    private boolean _needClientAuth = false;
    private boolean _usingHttps = false;
    private int connectTimeout;

    public static HTTPSocketFactory getInstance() {
        if (_instance == null) {
            _instance = new HTTPSocketFactory();
        }
        return _instance;
    }

    public void configure(Profile profile, HTTPAddress hta) throws Exception {
        if (hta.getProto().equals("https")) {
            this._usingHttps = true;
            try {
                String trustManagerClass = profile.getParameter("jade_mtp_http_https_trustManagerClass", "jade.mtp.http.https.NoAuthentication");
                String keyManagerClass = profile.getParameter("jade_mtp_http_https_keyManagerClass", "jade.mtp.http.https.KeyStoreKeyManager");
                HTTPSTrustManager tm = (HTTPSTrustManager)Class.forName(trustManagerClass).newInstance();
                tm.init(profile);
                HTTPSKeyManager km = (HTTPSKeyManager)Class.forName(keyManagerClass).newInstance();
                km.init(profile);
                if (profile.getParameter("jade_mtp_http_https_needClientAuth", "no").equals("yes")) {
                    this._needClientAuth = true;
                }
                SSLContext sctx = SSLContext.getInstance("TLS");
                sctx.init(new KeyManager[]{km}, new TrustManager[]{tm}, null);
                this._socketFactory = sctx.getSocketFactory();
                this._serverSocketFactory = sctx.getServerSocketFactory();
            }
            catch (Exception e) {
                throw new MTPException("Error initializing secure conection", e);
            }
        } else {
            this._socketFactory = SocketFactory.getDefault();
            this._serverSocketFactory = ServerSocketFactory.getDefault();
        }
        this.connectTimeout = Integer.parseInt(profile.getParameter("jade_mtp_http_connectTimeout", Integer.toString(-1)));
    }

    public Socket createSocket(String host, int port) throws IOException {
        Socket s;
        if (this.connectTimeout == -1) {
            s = this._socketFactory.createSocket(host, port);
        } else {
            s = this._socketFactory.createSocket();
            s.connect(new InetSocketAddress(host, port), this.connectTimeout);
        }
        return s;
    }

    public Socket createSocket(String host, int port, InetAddress dest, int outport) throws IOException {
        Socket s;
        if (this.connectTimeout == -1) {
            s = this._socketFactory.createSocket(host, port, dest, outport);
        } else {
            s = this._socketFactory.createSocket();
            s.bind(new InetSocketAddress(dest, outport));
            s.connect(new InetSocketAddress(host, port), this.connectTimeout);
        }
        return s;
    }

    public ServerSocket createServerSocket(String interfaceAddress, int port) throws IOException {
        InetAddress ifAddr = interfaceAddress == null || interfaceAddress.equals("localhost") ? null : InetAddress.getByName(interfaceAddress);
        ServerSocket ss = this._serverSocketFactory.createServerSocket(port, 0, ifAddr);
        if (this._usingHttps) {
            ((SSLServerSocket)ss).setNeedClientAuth(this._needClientAuth);
        }
        return ss;
    }

    private HTTPSocketFactory() {
    }
}

