/*
 * Decompiled with CFR 0.152.
 */
package jade.proto.states;

import jade.core.Agent;
import jade.core.behaviours.DataStore;
import jade.core.behaviours.SimpleBehaviour;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;

public class MsgReceiver
extends SimpleBehaviour {
    public static final int TIMEOUT_EXPIRED = -1001;
    public static final int INTERRUPTED = -1002;
    public static final int INFINITE = -1;
    protected MessageTemplate template;
    protected long deadline;
    protected Object receivedMsgKey;
    private boolean received;
    private boolean expired;
    private boolean interrupted;
    private int ret;

    public MsgReceiver(Agent a, MessageTemplate mt, long deadline, DataStore s, Object msgKey) {
        super(a);
        this.setDataStore(s);
        this.template = mt;
        this.deadline = deadline;
        this.receivedMsgKey = msgKey;
        this.received = false;
        this.expired = false;
        this.interrupted = false;
    }

    protected MsgReceiver() {
    }

    public void action() {
        if (this.interrupted) {
            if (this.receivedMsgKey != null) {
                this.getDataStore().put(this.receivedMsgKey, null);
            }
            this.ret = -1002;
            return;
        }
        ACLMessage msg = this.myAgent.receive(this.template);
        if (msg != null) {
            if (this.receivedMsgKey != null) {
                this.getDataStore().put(this.receivedMsgKey, msg);
            }
            this.received = true;
            this.ret = msg.getPerformative();
            this.handleMessage(msg);
        } else if (this.deadline >= 0L) {
            long blockTime = this.deadline - System.currentTimeMillis();
            if (blockTime <= 0L) {
                if (this.receivedMsgKey != null) {
                    this.getDataStore().put(this.receivedMsgKey, null);
                }
                this.expired = true;
                this.ret = -1001;
                this.handleMessage(null);
            } else {
                this.block(blockTime);
            }
        } else {
            this.block();
        }
    }

    public boolean done() {
        return this.received || this.expired || this.interrupted;
    }

    public int onEnd() {
        this.received = false;
        this.expired = false;
        this.interrupted = false;
        return this.ret;
    }

    protected void handleMessage(ACLMessage msg) {
    }

    public void reset(MessageTemplate mt, long deadline, DataStore s, Object msgKey) {
        super.reset();
        this.received = false;
        this.expired = false;
        this.interrupted = false;
        this.setTemplate(mt);
        this.setDeadline(deadline);
        this.setDataStore(s);
        this.setReceivedKey(msgKey);
    }

    public void setDeadline(long deadline) {
        this.deadline = deadline;
    }

    public void setTemplate(MessageTemplate mt) {
        this.template = mt;
    }

    public void setReceivedKey(Object key) {
        this.receivedMsgKey = key;
    }

    public void interrupt() {
        this.interrupted = true;
        this.restart();
    }
}

