/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.sniffer;

import jade.gui.AgentTree;
import jade.tools.sniffer.AgentAction;
import jade.tools.sniffer.ClearCanvasAction;
import jade.tools.sniffer.DisplayLogFileAction;
import jade.tools.sniffer.DoNotSnifferAction;
import jade.tools.sniffer.DoSnifferAction;
import jade.tools.sniffer.ExitAction;
import jade.tools.sniffer.FixedAction;
import jade.tools.sniffer.MainPanel;
import jade.tools.sniffer.ShowOnlyAction;
import jade.tools.sniffer.Sniffer;
import jade.tools.sniffer.SnifferAction;
import jade.tools.sniffer.StartException;
import jade.tools.sniffer.WriteLogFileAction;
import jade.tools.sniffer.WriteMessageListAction;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.TreePath;

class ActionProcessor {
    public static final String CLEARCANVAS_ACTION = "ClearCanvasAction";
    public static final String DISPLAYLOGFILE_ACTION = "DisplayLogFileAction";
    public static final String WRITELOGFILE_ACTION = "WriteLogFileAction";
    public static final String WRITEMESSAGELIST_ACTION = "MessageFileAction";
    public static final String EXIT_SNIFFER_ACTION = "ExitSnifferAction";
    public static final String DO_SNIFFER_ACTION = "DoSnifferAction";
    public static final String DO_NOT_SNIFFER_ACTION = "DoNotSnifferAction";
    public static final String SWOW_ONLY_ACTION = "ShowOnlyAction";
    public static final Map actions = new HashMap(5);
    private MainPanel mainPanel;
    private SnifferAction action;

    public ActionProcessor(Sniffer mySniffer, MainPanel mainPanel) {
        this.mainPanel = mainPanel;
        actions.put(CLEARCANVAS_ACTION, new ClearCanvasAction(this, mainPanel));
        actions.put(DISPLAYLOGFILE_ACTION, new DisplayLogFileAction(this, mainPanel));
        actions.put(WRITELOGFILE_ACTION, new WriteLogFileAction(this, mainPanel));
        actions.put(WRITEMESSAGELIST_ACTION, new WriteMessageListAction(this, mainPanel));
        actions.put(EXIT_SNIFFER_ACTION, new ExitAction(this, mySniffer));
        actions.put(DO_SNIFFER_ACTION, new DoSnifferAction(this, mainPanel, mySniffer));
        actions.put(DO_NOT_SNIFFER_ACTION, new DoNotSnifferAction(this, mainPanel, mySniffer));
        actions.put(SWOW_ONLY_ACTION, new ShowOnlyAction(this, mainPanel, mySniffer));
    }

    public void process(SnifferAction act) {
        this.action = act;
        TreePath[] paths = this.mainPanel.treeAgent.tree.getSelectionPaths();
        if (this.action instanceof FixedAction) {
            this.fixedAct();
        } else if (paths != null) {
            int lungpath = paths.length;
            for (int i = 0; i < lungpath; ++i) {
                AgentTree.Node now = (AgentTree.Node)paths[i].getLastPathComponent();
                this.agentAct(now);
            }
        }
    }

    private void fixedAct() {
        FixedAction fx = (FixedAction)this.action;
        fx.doAction();
    }

    private void agentAct(AgentTree.Node node) {
        AgentAction ag = (AgentAction)this.action;
        try {
            if (!(node instanceof AgentTree.AgentNode)) {
                throw new StartException();
            }
            AgentTree.AgentNode nod = (AgentTree.AgentNode)node;
            ag.doAction(nod);
        }
        catch (StartException a) {
            a.handle();
        }
    }
}

