/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.belief;

import bdi4jade.belief.Belief;
import bdi4jade.belief.BeliefBase;
import bdi4jade.core.MetadataElementImpl;
import bdi4jade.event.BeliefEvent;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractBelief<K, V>
extends MetadataElementImpl
implements Belief<K, V> {
    private static final long serialVersionUID = 5098122115249071355L;
    private final Set<BeliefBase> beliefBases;
    private K name;

    public AbstractBelief() {
        this.beliefBases = new HashSet<BeliefBase>();
    }

    public AbstractBelief(K name) {
        if (name == null) {
            throw new NullPointerException("Belief name must be not null.");
        }
        this.name = name;
        this.beliefBases = new HashSet<BeliefBase>();
    }

    public AbstractBelief(K name, V value) {
        this(name);
        this.updateValue(value);
    }

    @Override
    public void addBeliefBase(BeliefBase beliefBase) {
        this.beliefBases.add(beliefBase);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AbstractBelief clone = (AbstractBelief)super.clone();
        clone.beliefBases.clear();
        return clone;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof Belief) {
            Belief b = (Belief)obj;
            return this.name.equals(b.getName());
        }
        return false;
    }

    @Override
    public Set<BeliefBase> getBeliefBases() {
        return new HashSet<BeliefBase>(this.beliefBases);
    }

    @Override
    public final K getName() {
        return this.name;
    }

    public final int hashCode() {
        return this.name == null ? 0 : this.name.hashCode();
    }

    protected void notifyBeliefBases(BeliefEvent beliefEvent) {
        for (BeliefBase beliefBase : this.beliefBases) {
            beliefBase.notifyBeliefChanged(beliefEvent);
        }
    }

    @Override
    public void removeBeliefBase(BeliefBase beliefBase) {
        this.beliefBases.remove(beliefBase);
    }

    public void setName(K name) {
        this.name = name;
    }

    @Override
    public final void setValue(V value) {
        Object oldValue = this.getValue();
        this.updateValue(value);
        this.notifyBeliefBases(new BeliefEvent(this, BeliefEvent.Action.BELIEF_UPDATED, oldValue));
    }

    public String toString() {
        return new StringBuffer().append(this.name).append(" = ").append(this.getValue()).toString();
    }

    protected abstract void updateValue(V var1);
}

