/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.core;

import bdi4jade.core.Capability;
import bdi4jade.core.Intention;
import bdi4jade.event.GoalListener;
import bdi4jade.goal.Goal;
import bdi4jade.goal.GoalStatus;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class GoalUpdateSet {
    private final Set<GoalDescription> currentGoals = new HashSet<GoalDescription>();
    private final Set<GoalDescription> droppedGoals = new HashSet<GoalDescription>();
    private final Set<GoalDescription> generatedGoals = new HashSet<GoalDescription>();

    GoalUpdateSet() {
    }

    GoalUpdateSet(Collection<Intention> intentions) {
        this();
        for (Intention intention : intentions) {
            this.currentGoals.add(new GoalDescription(intention));
        }
    }

    void addIntention(Intention intention) {
        this.currentGoals.add(new GoalDescription(intention));
    }

    public void dropGoal(GoalDescription goal) {
        this.droppedGoals.add(goal);
    }

    public void generateGoal(Goal goal) {
        this.generatedGoals.add(new GoalDescription(goal));
    }

    public void generateGoal(Goal goal, Capability dispatcher) {
        this.generatedGoals.add(new GoalDescription(goal, dispatcher, null));
    }

    public void generateGoal(Goal goal, Capability dispatcher, GoalListener listener) {
        this.generatedGoals.add(new GoalDescription(goal, dispatcher, listener));
    }

    public void generateGoal(Goal goal, GoalListener listener) {
        this.generatedGoals.add(new GoalDescription(goal, null, listener));
    }

    public Set<GoalDescription> getCurrentGoals() {
        return new HashSet<GoalDescription>(this.currentGoals);
    }

    public Set<GoalDescription> getDroppedGoals() {
        return new HashSet<GoalDescription>(this.droppedGoals);
    }

    public Set<GoalDescription> getGeneratedGoals() {
        return new HashSet<GoalDescription>(this.generatedGoals);
    }

    boolean removeIntention(GoalDescription goalDescription) {
        return this.currentGoals.remove(goalDescription);
    }

    public class GoalDescription {
        private final Capability dispatcher;
        private final Goal goal;
        private final Intention intention;
        private final GoalListener listener;
        private final GoalStatus status;

        private GoalDescription(Goal goal) {
            this(goal, null, null);
        }

        private GoalDescription(Goal goal, Capability dispatcher, GoalListener listener) {
            this.goal = goal;
            this.status = null;
            this.dispatcher = dispatcher;
            this.listener = listener;
            this.intention = null;
        }

        private GoalDescription(Intention intention) {
            this.goal = intention.getGoal();
            this.status = intention.getStatus();
            this.dispatcher = intention.getDispatcher();
            this.listener = null;
            this.intention = intention;
        }

        public Capability getDispatcher() {
            return this.dispatcher;
        }

        public Goal getGoal() {
            return this.goal;
        }

        Intention getIntention() {
            return this.intention;
        }

        public GoalListener getListener() {
            return this.listener;
        }

        public GoalStatus getStatus() {
            return this.status;
        }
    }
}

