package bdi4jade.extension.undo;

/**
 * @author João Faccin
 */
public class Pair<T1, T2> {

	protected T1 key;
	protected T2 value;

	public Pair() {
		this.key = null;
		this.value = null;
	}

	public Pair(T1 key, T2 value) {
		this.key = key;
		this.value = value;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Pair other = (Pair) obj;
		if (key == null) {
			if (other.key != null)
				return false;
		} else if (!key.equals(other.key))
			return false;
		if (value == null) {
			if (other.value != null)
				return false;
		} else if (!value.equals(other.value))
			return false;
		return true;
	}

	public T1 getKey() {
		return key;
	}

	public T2 getValue() {
		return value;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((key == null) ? 0 : key.hashCode());
		result = prime * result + ((value == null) ? 0 : value.hashCode());
		return result;
	}

	public void setKey(T1 key) {
		this.key = key;
	}

	public void setValue(T2 value) {
		this.value = value;
	}

	@Override
	public String toString() {
		return "<" + key + ", " + value + ">";
	}

}