package bdi4jade.extension.remediation;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PlanRequiredResource {

	public static final String METADATA_NAME = PlanRequiredResource.class.getSimpleName();

	private final Map<Resource, Double> requiredResources;

	public PlanRequiredResource() {
		this.requiredResources = new HashMap<>();
	}

	public Double getRequiredResource(Resource resource) {
		return this.requiredResources.get(resource);
	}

	public Map<Resource, Double> getRequiredResources() {
		return requiredResources;
	}

	public Set<Resource> getResources() {
		return requiredResources.keySet();
	}

	public void setRequiredResource(Resource resource, Double value) {
		this.requiredResources.put(resource, value);
	}

}
