//----------------------------------------------------------------------------
// Copyright (C) 2011  Ingrid Nunes
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// 
// To contact the authors:
// http://inf.ufrgs.br/prosoft/bdi4jade/
//
//----------------------------------------------------------------------------

package bdi4jade.extension.remediation.logics;

import java.util.Map;

import bdi4jade.belief.BeliefBase;
import bdi4jade.belief.PredicateBelief;

/**
 * @author ingridnunes
 *
 */
public abstract class Predicate implements LogicalExpression {

	public String getStatement() {
		return toString();
	}

	@Override
	public Boolean getValue(BeliefBase beliefBase) {
		PredicateBelief<Predicate> belief = (PredicateBelief<Predicate>) beliefBase.getBelief(this);
		if (belief != null) {
			return belief.getValue();
		}
		return null;
	}

	@Override
	public Boolean getValue(Map<Object, Object> values) {
		return (Boolean) values.get(this);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return this.getClass().getSimpleName();
	}

}
