/*
 * Decompiled with CFR 0.152.
 */
package jade.core.messaging;

import jade.core.AID;
import jade.core.GenericCommand;
import jade.core.IMTPException;
import jade.core.Node;
import jade.core.NotFoundException;
import jade.core.ServiceException;
import jade.core.SliceProxy;
import jade.core.messaging.GenericMessage;
import jade.core.messaging.PersistentDeliverySlice;

public class PersistentDeliveryProxy
extends SliceProxy
implements PersistentDeliverySlice {
    public boolean storeMessage(String storeName, GenericMessage msg, AID receiver) throws IMTPException, NotFoundException {
        try {
            GenericCommand cmd = new GenericCommand("5", "jade.core.messaging.PersistentDelivery", null);
            cmd.addParam(storeName);
            cmd.addParam(msg.getACLMessage());
            cmd.addParam(msg.getEnvelope());
            cmd.addParam(msg.getPayload());
            cmd.addParam(new Boolean(msg.hasForeignReceiver()));
            cmd.addParam(msg.getTraceID());
            cmd.addParam(receiver);
            Node n = this.getNode();
            Object result = n.accept(cmd);
            if (result != null && result instanceof Throwable) {
                if (result instanceof IMTPException) {
                    throw (IMTPException)result;
                }
                if (result instanceof NotFoundException) {
                    throw (NotFoundException)result;
                }
                throw new IMTPException("An undeclared exception was thrown", (Throwable)result);
            }
            return (Boolean)result;
        }
        catch (ServiceException se) {
            throw new IMTPException("Unable to access remote node", se);
        }
    }

    public void flushMessages(AID receiver) throws IMTPException {
        try {
            GenericCommand cmd = new GenericCommand("6", "jade.core.messaging.PersistentDelivery", null);
            cmd.addParam(receiver);
            Node n = this.getNode();
            Object result = n.accept(cmd);
            if (result != null && result instanceof Throwable) {
                if (result instanceof IMTPException) {
                    throw (IMTPException)result;
                }
                throw new IMTPException("An undeclared exception was thrown", (Throwable)result);
            }
        }
        catch (ServiceException se) {
            throw new IMTPException("Unable to access remote node", se);
        }
    }
}

