/*
 * Decompiled with CFR 0.152.
 */
package jade.domain;

import jade.content.Concept;
import jade.content.Predicate;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Done;
import jade.content.onto.basic.Result;
import jade.domain.FIPAAgentManagement.APDescription;
import jade.domain.FIPAAgentManagement.Deregister;
import jade.domain.FIPAAgentManagement.GetDescription;
import jade.domain.FIPAAgentManagement.Modify;
import jade.domain.FIPAAgentManagement.Register;
import jade.domain.FIPAAgentManagement.Search;
import jade.domain.FIPAAgentManagement.UnsupportedFunction;
import jade.domain.FIPAException;
import jade.domain.RequestManagementBehaviour;
import jade.domain.ams;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.security.JADESecurityException;
import jade.util.leap.ArrayList;
import jade.util.leap.List;

class AMSFipaAgentManagementBehaviour
extends RequestManagementBehaviour {
    private ams theAMS;

    protected AMSFipaAgentManagementBehaviour(ams a, MessageTemplate mt) {
        super(a, mt);
        this.theAMS = a;
    }

    protected ACLMessage performAction(Action slAction, ACLMessage request) throws JADESecurityException, FIPAException {
        Concept action = slAction.getAction();
        List resultItems = null;
        if (action instanceof Register) {
            this.theAMS.registerAction((Register)action, request.getSender());
        } else if (action instanceof Deregister) {
            this.theAMS.deregisterAction((Deregister)action, request.getSender());
        } else if (action instanceof Modify) {
            this.theAMS.modifyAction((Modify)action, request.getSender());
        } else if (action instanceof Search) {
            resultItems = this.theAMS.searchAction((Search)action, request.getSender());
        } else if (action instanceof GetDescription) {
            APDescription dsc = this.theAMS.getDescriptionAction(request.getSender());
            resultItems = new ArrayList();
            resultItems.add(dsc);
        } else {
            throw new UnsupportedFunction();
        }
        ACLMessage notification = request.createReply();
        notification.setPerformative(7);
        Predicate p = null;
        p = resultItems != null ? new Result(slAction, resultItems) : new Done(slAction);
        try {
            this.theAMS.getContentManager().fillContent(notification, p);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return notification;
    }
}

