/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.http;

import jade.imtp.leap.JICP.Connection;
import jade.imtp.leap.JICP.JICPPacket;
import jade.imtp.leap.http.HTTPHelper;
import jade.imtp.leap.http.HTTPResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

class HTTPServerConnection
extends Connection {
    private Socket sc;
    private InputStream is;
    private OutputStream os;
    private boolean readAvailable;
    private boolean writeAvailable;

    public HTTPServerConnection(Socket s) {
        this.sc = s;
        this.readAvailable = true;
        this.writeAvailable = false;
    }

    public JICPPacket readPacket() throws IOException {
        if (this.readAvailable) {
            JICPPacket pkt = HTTPHelper.readPacketFromHttp(this.sc.getInputStream());
            this.readAvailable = false;
            this.writeAvailable = true;
            return pkt;
        }
        throw new IOException("Read not available");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writePacket(JICPPacket pkt) throws IOException {
        if (this.writeAvailable) {
            int n;
            try {
                HTTPResponse response = HTTPHelper.wrapInHttp(pkt);
                this.os = this.sc.getOutputStream();
                response.writeTo(this.os);
                this.os.flush();
                this.readAvailable = true;
                this.writeAvailable = false;
                n = response.getPayload().length;
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    this.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                this.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            return n;
        }
        throw new IOException("Write not available");
    }

    public void close() throws IOException {
        this.readAvailable = false;
        this.writeAvailable = false;
        try {
            this.is.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.is = null;
        try {
            this.os.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.os = null;
        try {
            this.sc.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sc = null;
    }

    public String getRemoteHost() throws Exception {
        return this.sc.getInetAddress().getHostAddress();
    }
}

