/*
 * Decompiled with CFR 0.152.
 */
package jade.proto;

import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.DataStore;
import jade.core.behaviours.SimpleBehaviour;
import jade.domain.FIPAAgentManagement.FailureException;
import jade.domain.FIPAAgentManagement.NotUnderstoodException;
import jade.domain.FIPAAgentManagement.RefuseException;
import jade.domain.FIPANames;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.AchieveREResponder;
import jade.util.leap.Iterator;

public class SimpleAchieveREResponder
extends SimpleBehaviour
implements FIPANames.InteractionProtocol {
    private static final int WAITING_MSG_STATE = 0;
    private static final int PREPARE_RESPONSE_STATE = 1;
    private static final int SEND_RESPONSE_STATE = 2;
    private static final int PREPARE_RES_NOT_STATE = 3;
    private static final int SEND_RESULT_NOTIFICATION_STATE = 4;
    private static final int RESET_STATE = 5;
    public final String REQUEST_KEY = "_request" + this.hashCode();
    public final String RESPONSE_KEY = "_response" + this.hashCode();
    public final String RESULT_NOTIFICATION_KEY = "_result-notification" + this.hashCode();
    private MessageTemplate template;
    private int state = 0;
    private boolean finished = false;

    public static MessageTemplate createMessageTemplate(String iprotocol) {
        return AchieveREResponder.createMessageTemplate(iprotocol);
    }

    public SimpleAchieveREResponder(Agent a, MessageTemplate mt) {
        this(a, mt, new DataStore());
    }

    public SimpleAchieveREResponder(Agent a, MessageTemplate mt, DataStore store) {
        super(a);
        this.setDataStore(store);
        this.template = mt;
        this.finished = false;
    }

    public final void action() {
        switch (this.state) {
            case 0: {
                ACLMessage request = this.myAgent.receive(this.template);
                if (request != null) {
                    this.getDataStore().put(this.REQUEST_KEY, request);
                    this.state = 1;
                    break;
                }
                this.block();
                break;
            }
            case 1: {
                DataStore ds = this.getDataStore();
                ACLMessage request = (ACLMessage)ds.get(this.REQUEST_KEY);
                ACLMessage response = null;
                this.state = 2;
                try {
                    response = this.prepareResponse(request);
                }
                catch (NotUnderstoodException nue) {
                    response = request.createReply();
                    response.setContent(nue.getMessage());
                    response.setPerformative(10);
                }
                catch (RefuseException re) {
                    response = request.createReply();
                    response.setContent(re.getMessage());
                    response.setPerformative(14);
                }
                ds.put(this.RESPONSE_KEY, response);
                break;
            }
            case 2: {
                DataStore ds = this.getDataStore();
                ACLMessage response = (ACLMessage)ds.get(this.RESPONSE_KEY);
                if (response != null) {
                    ACLMessage receivedMsg = (ACLMessage)ds.get(this.REQUEST_KEY);
                    response = this.arrangeMessage(receivedMsg, response);
                    this.myAgent.send(response);
                    if (response.getPerformative() == 1) {
                        this.state = 3;
                        break;
                    }
                    this.state = 5;
                    break;
                }
                this.state = 3;
                break;
            }
            case 3: {
                this.state = 4;
                DataStore ds = this.getDataStore();
                ACLMessage request = (ACLMessage)ds.get(this.REQUEST_KEY);
                ACLMessage response = (ACLMessage)ds.get(this.RESPONSE_KEY);
                ACLMessage resNotification = null;
                try {
                    resNotification = this.prepareResultNotification(request, response);
                }
                catch (FailureException fe) {
                    resNotification = request.createReply();
                    resNotification.setContent(fe.getMessage());
                    resNotification.setPerformative(6);
                }
                ds.put(this.RESULT_NOTIFICATION_KEY, resNotification);
                break;
            }
            case 4: {
                this.state = 5;
                DataStore ds = this.getDataStore();
                ACLMessage resNotification = (ACLMessage)ds.get(this.RESULT_NOTIFICATION_KEY);
                if (resNotification == null) break;
                ACLMessage receivedMsg = (ACLMessage)ds.get(this.REQUEST_KEY);
                this.myAgent.send(this.arrangeMessage(receivedMsg, resNotification));
                break;
            }
            case 5: {
                this.reset();
            }
        }
    }

    protected ACLMessage prepareResponse(ACLMessage request) throws NotUnderstoodException, RefuseException {
        System.out.println("prepareResponse() method not re-defined");
        return null;
    }

    protected ACLMessage prepareResultNotification(ACLMessage request, ACLMessage response) throws FailureException {
        System.out.println("prepareResultNotification() method not re-defined");
        return null;
    }

    public void reset() {
        this.finished = false;
        this.state = 0;
        DataStore ds = this.getDataStore();
        ds.remove(this.REQUEST_KEY);
        ds.remove(this.RESPONSE_KEY);
        ds.remove(this.RESULT_NOTIFICATION_KEY);
        super.reset();
    }

    public void reset(MessageTemplate mt) {
        this.template = mt;
        this.reset();
    }

    public boolean done() {
        return this.finished;
    }

    private ACLMessage arrangeMessage(ACLMessage request, ACLMessage reply) {
        reply.setConversationId(request.getConversationId());
        reply.setInReplyTo(request.getReplyWith());
        reply.setProtocol(request.getProtocol());
        if (!reply.getAllReceiver().hasNext()) {
            Iterator it = request.getAllReplyTo();
            int r = 0;
            while (it.hasNext()) {
                reply.addReceiver((AID)it.next());
                ++r;
            }
            if (r == 0) {
                reply.addReceiver(request.getSender());
            }
        }
        return reply;
    }
}

