/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.util.plan;

import bdi4jade.event.GoalFinishedEvent;
import bdi4jade.goal.Goal;
import bdi4jade.goal.GoalStatus;
import bdi4jade.plan.OutputPlanBody;
import bdi4jade.plan.PlanBody;
import bdi4jade.plan.PlanInstance;
import bdi4jade.util.goal.ParallelGoal;
import jade.core.behaviours.Behaviour;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ParallelGoalPlanBody
extends Behaviour
implements PlanBody,
OutputPlanBody {
    private static final long serialVersionUID = -5919677537834351951L;
    protected List<Goal> completedGoals;
    protected boolean dispatched;
    protected GoalFinishedEvent failedGoal;
    protected Log log = LogFactory.getLog(this.getClass());
    protected ParallelGoal parallelGoal;
    protected PlanInstance planInstance;
    protected Boolean success;

    public void action() {
        if (this.dispatched) {
            GoalFinishedEvent goalEvent = this.planInstance.getGoalEvent();
            if (goalEvent == null) {
                return;
            }
            if (GoalStatus.ACHIEVED.equals((Object)goalEvent.getStatus())) {
                this.completedGoals.add(goalEvent.getGoal());
                this.log.debug((Object)("Goal " + goalEvent.getGoal() + " completed!"));
                if (this.completedGoals.size() == this.parallelGoal.getGoals().size()) {
                    this.success = Boolean.TRUE;
                    this.log.debug((Object)"All goals completed.");
                }
            } else {
                this.failedGoal = goalEvent;
                this.success = Boolean.FALSE;
                this.log.debug((Object)("A goal has failed: " + goalEvent.getGoal()));
            }
        } else {
            for (Goal goal : this.parallelGoal.getGoals()) {
                this.planInstance.dispatchSubgoalAndListen(goal);
            }
            this.dispatched = true;
            this.log.debug((Object)"Goals dispatched!");
        }
    }

    public boolean done() {
        return this.success != null;
    }

    @Override
    public PlanInstance.EndState getEndState() {
        if (this.success == null) {
            return null;
        }
        return this.success != false ? PlanInstance.EndState.SUCCESSFUL : PlanInstance.EndState.FAILED;
    }

    @Override
    public void init(PlanInstance planInstance) {
        this.planInstance = planInstance;
        this.parallelGoal = (ParallelGoal)planInstance.getGoal();
        this.completedGoals = new ArrayList<Goal>(this.parallelGoal.getGoals().size());
        this.failedGoal = null;
        this.success = null;
        this.dispatched = false;
    }

    @Override
    public void setGoalOutput(Goal goal) {
        ParallelGoal parGoal = (ParallelGoal)goal;
        parGoal.setCompletedGoals(this.completedGoals);
        parGoal.setFailedGoal(this.failedGoal);
    }
}

