/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.util.plan;

import bdi4jade.event.GoalFinishedEvent;
import bdi4jade.goal.Goal;
import bdi4jade.goal.GoalStatus;
import bdi4jade.plan.OutputPlanBody;
import bdi4jade.plan.PlanBody;
import bdi4jade.plan.PlanInstance;
import bdi4jade.util.goal.SequentialGoal;
import jade.core.behaviours.Behaviour;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SequentialGoalPlanBody
extends Behaviour
implements PlanBody,
OutputPlanBody {
    private static final long serialVersionUID = -5919677537834351951L;
    protected List<Goal> completedGoals;
    protected Goal currentGoal;
    protected GoalFinishedEvent failedGoal;
    protected Iterator<Goal> it;
    protected Log log = LogFactory.getLog(this.getClass());
    protected PlanInstance planInstance;
    protected Boolean success;

    public void action() {
        if (this.currentGoal == null) {
            if (!this.it.hasNext()) {
                this.success = Boolean.TRUE;
                this.log.debug((Object)"All goals completed.");
            } else {
                this.currentGoal = this.it.next();
                if (!this.completedGoals.isEmpty()) {
                    this.setNextGoal(this.completedGoals.get(this.completedGoals.size() - 1), this.currentGoal);
                }
                this.planInstance.dispatchSubgoalAndListen(this.currentGoal);
                this.log.debug((Object)("Dispatching goal: " + this.currentGoal));
            }
        } else {
            GoalFinishedEvent goalEvent = this.planInstance.getGoalEvent();
            if (goalEvent == null) {
                return;
            }
            if (GoalStatus.ACHIEVED.equals((Object)goalEvent.getStatus())) {
                this.completedGoals.add(goalEvent.getGoal());
                this.currentGoal = null;
                this.log.debug((Object)("Goal " + goalEvent.getGoal() + " completed!"));
            } else {
                this.failedGoal = goalEvent;
                this.success = Boolean.FALSE;
                this.log.debug((Object)("A goal has failed: " + goalEvent.getGoal()));
            }
        }
    }

    public boolean done() {
        return this.success != null;
    }

    @Override
    public PlanInstance.EndState getEndState() {
        if (this.success == null) {
            return null;
        }
        return this.success != false ? PlanInstance.EndState.SUCCESSFUL : PlanInstance.EndState.FAILED;
    }

    @Override
    public void init(PlanInstance planInstance) {
        this.planInstance = planInstance;
        SequentialGoal goal = (SequentialGoal)planInstance.getGoal();
        this.it = goal.getGoals().iterator();
        this.success = null;
        this.currentGoal = null;
        this.failedGoal = null;
        this.completedGoals = new ArrayList<Goal>(goal.getGoals().size());
    }

    @Override
    public void setGoalOutput(Goal goal) {
        SequentialGoal seqGoal = (SequentialGoal)goal;
        seqGoal.setCompletedGoals(this.completedGoals);
        seqGoal.setFailedGoal(this.failedGoal);
    }

    protected void setNextGoal(Goal previousGoal, Goal goal) {
    }
}

