/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.IMTPException;
import jade.core.IMTPManager;
import jade.core.Node;
import jade.core.NodeDescriptor;
import jade.core.PlatformManager;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.util.Logger;
import jade.util.leap.HashMap;
import jade.util.leap.Map;

public class BackEndManager {
    private static BackEndManager theInstance;
    protected IMTPManager myIMTPManager;
    private Node myNode;
    private Map children = new HashMap();
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());

    public static BackEndManager getInstance(Profile p) throws ProfileException {
        if (theInstance == null) {
            theInstance = new BackEndManager(p);
        }
        return theInstance;
    }

    private BackEndManager(Profile p) throws ProfileException {
        if (p != null) {
            this.myIMTPManager = p.getIMTPManager();
            try {
                this.myNode = this.myIMTPManager.getLocalNode();
            }
            catch (IMTPException imtpe) {
                throw new ProfileException("Cannot retrieve local node.", imtpe);
            }
        } else {
            throw new ProfileException("Cannot create BackEndManager: Null profile");
        }
    }

    public Node getNode() {
        return this.myNode;
    }

    public synchronized void register(NodeDescriptor child) {
        this.children.put(child.getName(), child);
        if (this.myLogger.isLoggable(Logger.CONFIG)) {
            this.myLogger.log(Logger.CONFIG, "Child node " + child.getName() + " registered.");
        }
    }

    public synchronized void deregister(NodeDescriptor child) {
        try {
            NodeDescriptor dsc = (NodeDescriptor)this.children.remove(child.getName());
            PlatformManager pm = this.myIMTPManager.getPlatformManagerProxy();
            pm.removeNode(dsc, false);
            if (this.myLogger.isLoggable(Logger.CONFIG)) {
                this.myLogger.log(Logger.CONFIG, "Child node " + child.getName() + " deregistered.");
            }
        }
        catch (Exception e) {
            this.myLogger.log(Logger.WARNING, "Error deregistering child node " + child.getName() + ". " + e);
            e.printStackTrace();
        }
    }
}

