/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.Agent;
import jade.util.leap.Serializable;
import java.lang.reflect.Method;

public class CallbackInvokator
implements Serializable {
    CallbackInvokator() {
    }

    public void invokeCallbackMethod(Agent a, String name) {
        this.recursiveInvoke(a, a.getClass(), name);
    }

    private void recursiveInvoke(Agent a, Class agentClass, String name) {
        Method callbackMethod = null;
        try {
            callbackMethod = agentClass.getDeclaredMethod(name, null);
            boolean accessibilityChanged = false;
            if (!callbackMethod.isAccessible()) {
                try {
                    callbackMethod.setAccessible(true);
                    accessibilityChanged = true;
                }
                catch (SecurityException se) {
                    System.out.println("Callback method " + name + "() of agent " + a.getName() + " not accessible.");
                }
            }
            try {
                callbackMethod.invoke((Object)a, (Object[])null);
                if (accessibilityChanged) {
                    callbackMethod.setAccessible(false);
                }
            }
            catch (Exception e) {
                System.out.println("Error executing callback method " + name + "() of agent " + a.getName() + ". " + e);
            }
        }
        catch (NoSuchMethodException e) {
            Class superClass = agentClass.getSuperclass();
            if (superClass != null) {
                this.recursiveInvoke(a, superClass, name);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }
}

