/*
 * Decompiled with CFR 0.152.
 */
package jade.core.sam;

import jade.core.Agent;
import jade.core.AgentContainer;
import jade.core.BaseService;
import jade.core.Filter;
import jade.core.HorizontalCommand;
import jade.core.IMTPException;
import jade.core.Node;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.Service;
import jade.core.ServiceException;
import jade.core.ServiceHelper;
import jade.core.Specifier;
import jade.core.VerticalCommand;
import jade.core.sam.AverageMeasure;
import jade.core.sam.AverageMeasureProvider;
import jade.core.sam.CounterValueProvider;
import jade.core.sam.MeasureProvider;
import jade.core.sam.Poller;
import jade.core.sam.SAMHelper;
import jade.core.sam.SAMInfo;
import jade.core.sam.SAMInfoHandler;
import jade.core.sam.SAMSlice;
import jade.util.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMService
extends BaseService {
    public static final String POLLING_PERIOD = "jade_core_sam_SAMService_pollingperiod";
    public static final int POLLING_PERIOD_DEFAULT = 1;
    public static final String SAM_INFO_HANDLERS = "jade_core_sam_SAMService_handlers";
    public static final String SAM_INFO_HANDLERS_DEFAULT = "jade.core.sam.DefaultSAMInfoHandlerImpl";
    private List<EntityInfo> monitoredEntities = new ArrayList<EntityInfo>();
    private List<CounterInfo> monitoredCounters = new ArrayList<CounterInfo>();
    private Poller poller;
    private SAMHelper myHelper = new SAMHelperImpl();
    private ServiceComponent localSlice = new ServiceComponent();
    private Filter outgoingFilter = null;
    private Profile myProfile;

    @Override
    public String getName() {
        return "jade.core.sam.SAM";
    }

    @Override
    public void init(AgentContainer ac, Profile p) throws ProfileException {
        super.init(ac, p);
        if (p.isMain()) {
            this.outgoingFilter = new Filter(){

                public boolean accept(VerticalCommand cmd) {
                    String name = cmd.getName();
                    try {
                        if (name.equals("Shutdown-Platform")) {
                            if (SAMService.this.poller != null) {
                                SAMService.this.poller.stopPolling();
                            }
                        } else if (name.equals("Leadership-Acquired")) {
                            SAMService.this.startPolling();
                        }
                    }
                    catch (Exception e) {
                        SAMService.this.myLogger.log(Logger.WARNING, "Error processing command " + name + ". ", e);
                    }
                    return true;
                }
            };
        }
    }

    @Override
    public void boot(Profile p) throws ServiceException {
        super.boot(p);
        this.myProfile = p;
        if (this.myProfile.isMasterMain()) {
            this.startPolling();
        }
    }

    private void startPolling() throws ServiceException {
        int periodMinutes = 1;
        try {
            periodMinutes = Integer.parseInt(this.myProfile.getParameter(POLLING_PERIOD, null));
        }
        catch (Exception e) {
            // empty catch block
        }
        this.myLogger.log(Logger.CONFIG, "Polling period = " + periodMinutes + " minutes");
        try {
            String hh = this.myProfile.getParameter(SAM_INFO_HANDLERS, SAM_INFO_HANDLERS_DEFAULT);
            Vector handlerClasses = new Vector();
            if (!hh.equalsIgnoreCase("none")) {
                handlerClasses = Specifier.parseList(hh, ';');
            }
            SAMInfoHandler[] handlers = new SAMInfoHandler[handlerClasses.size()];
            for (int i = 0; i < handlerClasses.size(); ++i) {
                String className = (String)handlerClasses.get(i);
                this.myLogger.log(Logger.CONFIG, "Loading SAMInfoHandler class = " + className + "...");
                handlers[i] = (SAMInfoHandler)Class.forName(className).newInstance();
                handlers[i].initialize(this.myProfile);
                this.myLogger.log(Logger.CONFIG, "SAMInfoHandler of class = " + className + " successfully initialized");
            }
            this.poller = new Poller(this, periodMinutes * 60000, handlers);
            this.poller.startPolling();
        }
        catch (Exception e) {
            throw new ServiceException("Error initializing SAMInfoHandler", e);
        }
    }

    @Override
    public void shutdown() {
        if (this.poller != null) {
            this.poller.stopPolling();
        }
        super.shutdown();
    }

    @Override
    public Filter getCommandFilter(boolean direction) {
        if (direction) {
            return this.outgoingFilter;
        }
        return null;
    }

    @Override
    public ServiceHelper getHelper(Agent a) {
        return this.myHelper;
    }

    @Override
    public Class getHorizontalInterface() {
        return SAMSlice.class;
    }

    @Override
    public Service.Slice getLocalSlice() {
        return this.localSlice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, AverageMeasure> getEntityMeasures() {
        SAMHelper sAMHelper = this.myHelper;
        synchronized (sAMHelper) {
            HashMap<String, AverageMeasure> entityMeasures = new HashMap<String, AverageMeasure>();
            for (EntityInfo info : this.monitoredEntities) {
                entityMeasures.put(info.getName(), info.getMeasure());
            }
            return entityMeasures;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Long> getCounterValues() {
        SAMHelper sAMHelper = this.myHelper;
        synchronized (sAMHelper) {
            HashMap<String, Long> counterValues = new HashMap<String, Long>();
            for (CounterInfo info : this.monitoredCounters) {
                counterValues.put(info.getName(), info.getValue());
            }
            return counterValues;
        }
    }

    private EntityInfo getEntityInfo(String entityName) {
        for (EntityInfo info : this.monitoredEntities) {
            if (!info.getName().equals(entityName)) continue;
            return info;
        }
        EntityInfo info = new EntityInfo(entityName);
        this.monitoredEntities.add(info);
        return info;
    }

    private CounterInfo getCounterInfo(String counterName) {
        for (CounterInfo info : this.monitoredCounters) {
            if (!info.getName().equals(counterName)) continue;
            return info;
        }
        CounterInfo info = new CounterInfo(counterName);
        this.monitoredCounters.add(info);
        return info;
    }

    private class CounterInfo {
        private String name;
        private List<CounterValueProvider> providers = new ArrayList<CounterValueProvider>();
        private List<Long> previousTotalValues = new ArrayList<Long>();

        CounterInfo(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }

        void addProvider(CounterValueProvider provider) {
            this.providers.add(provider);
            this.previousTotalValues.add(0L);
        }

        long getValue() {
            long result = 0L;
            for (int i = 0; i < this.providers.size(); ++i) {
                CounterValueProvider p = this.providers.get(i);
                long v = p.getValue();
                if (p.isDifferential()) {
                    result += v;
                    continue;
                }
                result += v - this.previousTotalValues.get(i);
                this.previousTotalValues.set(i, v);
            }
            return result;
        }
    }

    private class EntityInfo {
        private String name;
        private List<AverageMeasureProvider> providers = new ArrayList<AverageMeasureProvider>();

        EntityInfo(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }

        void addProvider(AverageMeasureProvider provider) {
            this.providers.add(provider);
        }

        AverageMeasure getMeasure() {
            AverageMeasure result = new AverageMeasure();
            for (AverageMeasureProvider p : this.providers) {
                AverageMeasure m = p.getValue();
                result.update(m);
            }
            return result;
        }
    }

    private class ServiceComponent
    implements Service.Slice {
        private ServiceComponent() {
        }

        public Service getService() {
            return SAMService.this;
        }

        public Node getNode() throws ServiceException {
            try {
                return SAMService.this.getLocalNode();
            }
            catch (IMTPException imtpe) {
                throw new ServiceException("Problem contacting the IMTP Manager", imtpe);
            }
        }

        public VerticalCommand serve(HorizontalCommand cmd) {
            try {
                String cmdName = cmd.getName();
                if (cmdName.equals("1")) {
                    SAMInfo info = new SAMInfo(SAMService.this.getEntityMeasures(), SAMService.this.getCounterValues());
                    cmd.setReturnValue(info);
                }
            }
            catch (Throwable t) {
                cmd.setReturnValue(t);
            }
            return null;
        }
    }

    private class SAMHelperImpl
    implements SAMHelper {
        private SAMHelperImpl() {
        }

        public synchronized void addEntityMeasureProvider(String entityName, final MeasureProvider provider) {
            this.addEntityMeasureProvider(entityName, new AverageMeasureProvider(){

                public AverageMeasure getValue() {
                    Number value = provider.getValue();
                    if (value != null) {
                        return new AverageMeasure(value.doubleValue(), 1);
                    }
                    return new AverageMeasure(0.0, 0);
                }
            });
        }

        public synchronized void addEntityMeasureProvider(String entityName, AverageMeasureProvider provider) {
            EntityInfo info = SAMService.this.getEntityInfo(entityName);
            info.addProvider(provider);
        }

        public synchronized void addCounterValueProvider(String counterName, CounterValueProvider provider) {
            CounterInfo info = SAMService.this.getCounterInfo(counterName);
            info.addProvider(provider);
        }

        public void addHandler(SAMInfoHandler handler, boolean first) {
            if (SAMService.this.poller != null) {
                SAMService.this.poller.addHandler(handler, first);
            }
        }

        public void removeHandler(SAMInfoHandler handler) {
            if (SAMService.this.poller != null) {
                SAMService.this.poller.removeHandler(handler);
            }
        }

        public void init(Agent a) {
        }
    }
}

