/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.nio;

import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NIOHelper {
    public static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocateDirect(0);
    private static final Logger log = Logger.getLogger(NIOHelper.class.getName());

    private NIOHelper() {
    }

    public static void logBuffer(ByteBuffer b) {
        NIOHelper.logBuffer(b, "unknown");
    }

    public static void logBuffer(ByteBuffer b, String name) {
        NIOHelper.logBuffer(b, name, Level.FINE);
    }

    public static void logBuffer(ByteBuffer b, String name, Level l) {
        if (log.isLoggable(l)) {
            log.log(l, "bufferinfo {0}: pos {1}, rem {2}, lim {3}, cap {4}", new Object[]{name, b.position(), b.remaining(), b.limit(), b.capacity()});
        }
    }

    public static int copyAsMuchAsFits(ByteBuffer dst, ByteBuffer src) {
        if (dst.hasRemaining() && src.hasRemaining()) {
            int pos = dst.position();
            int limit = src.limit();
            if (src.remaining() > dst.remaining()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("setting limit of src buffer to " + (src.position() + dst.remaining()));
                }
                src.limit(src.position() + dst.remaining());
            }
            dst.put(src);
            src.limit(limit);
            if (log.isLoggable(Level.FINE)) {
                log.fine("bytes copied to dst " + (dst.position() - pos) + ", bytes left in src " + src.remaining());
                NIOHelper.logBuffer(src, "src");
                NIOHelper.logBuffer(dst, "dst");
            }
            return dst.position() - pos;
        }
        return 0;
    }

    public static ByteBuffer enlargeBuffer(ByteBuffer b, int extraSpace, String name) {
        return NIOHelper.enlargeBuffer(b, extraSpace, name, false);
    }

    public static ByteBuffer enlargeBuffer(ByteBuffer b, int extraSpace, String name, boolean doLog) {
        if (!doLog) {
            return ByteBuffer.allocateDirect(b.capacity() + extraSpace);
        }
        ByteBuffer bigger = ByteBuffer.allocateDirect(b.capacity() + extraSpace);
        NIOHelper.logBuffer(b, String.format("before resize %s", name), Level.WARNING);
        NIOHelper.logBuffer(bigger, String.format("after resize %s", name), Level.WARNING);
        return bigger;
    }

    public static ByteBuffer enlargeAndFillBuffer(ByteBuffer b, int extraSpace, String name) {
        ByteBuffer bigger = NIOHelper.enlargeBuffer(b, extraSpace, name, false);
        bigger.put(b);
        NIOHelper.logBuffer(b, String.format("before resize %s", name), Level.WARNING);
        NIOHelper.logBuffer(bigger, String.format("after resize %s", name), Level.WARNING);
        return bigger;
    }
}

