/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.nio;

import jade.imtp.leap.ICPException;
import jade.imtp.leap.JICP.Connection;
import jade.imtp.leap.JICP.JICPPacket;
import jade.imtp.leap.nio.BEManagementService;
import jade.imtp.leap.nio.BufferTransformer;
import jade.imtp.leap.nio.NIOHelper;
import jade.imtp.leap.nio.PacketIncompleteException;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NIOJICPConnection
extends Connection {
    public static final int MAX_HEADER_SIZE = 263;
    public static final int INITIAL_BUFFER_SIZE = 1024;
    private SocketChannel myChannel;
    private ByteBuffer socketData;
    private ByteBuffer payloadBuf;
    private ByteBuffer unmanagedJicpData = null;
    private byte type;
    private byte info;
    private byte sessionID;
    private String recipientID;
    private boolean headerReceived = false;
    private boolean closed = false;
    private List<BufferTransformerInfo> transformers;
    private static final Logger log = Logger.getLogger(NIOJICPConnection.class.getName());

    public NIOJICPConnection() {
        this.socketData = ByteBuffer.allocateDirect(1024);
        this.payloadBuf = ByteBuffer.allocateDirect(1024);
        this.transformers = new LinkedList<BufferTransformerInfo>();
    }

    protected NIOJICPConnection(boolean wrapper) {
    }

    public SocketChannel getChannel() {
        return this.myChannel;
    }

    public synchronized JICPPacket readPacket() throws IOException {
        block15: {
            ByteBuffer jicpData;
            block16: {
                block17: {
                    JICPPacket jICPPacket;
                    jicpData = null;
                    if (this.unmanagedJicpData == null) {
                        this.read();
                        jicpData = this.transformAfterRead(this.socketData);
                    } else {
                        jicpData = this.unmanagedJicpData;
                    }
                    try {
                        if (!jicpData.hasRemaining()) break block15;
                        if (this.headerReceived) break block16;
                        this.headerReceived = true;
                        this.type = jicpData.get();
                        this.info = jicpData.get();
                        this.sessionID = (byte)-1;
                        if ((this.info & 4) != 0) {
                            this.sessionID = jicpData.get();
                        }
                        if ((this.info & 2) != 0) {
                            byte recipientIDLength = jicpData.get();
                            byte[] bb = new byte[recipientIDLength];
                            jicpData.get(bb);
                            this.recipientID = new String(bb);
                        }
                        if ((this.info & 8) == 0) break block17;
                        byte b1 = jicpData.get();
                        byte b2 = jicpData.get();
                        int payloadLength = b2 << 8 & 0xFF00 | b1 & 0xFF;
                        byte b3 = jicpData.get();
                        byte b4 = jicpData.get();
                        if ((payloadLength |= b4 << 24 & 0xFF000000 | b3 << 16 & 0xFF0000) > 10000000) {
                            throw new IOException("Packet size greater than maximum allowed size. " + payloadLength);
                        }
                        this.resizePayloadBuffer(payloadLength);
                        NIOHelper.copyAsMuchAsFits(this.payloadBuf, jicpData);
                        if (this.payloadBuf.hasRemaining()) {
                            throw new PacketIncompleteException("Missing " + this.payloadBuf.remaining() + " payload bytes");
                        }
                        jICPPacket = this.buildPacket(jicpData);
                        Object var9_11 = null;
                    }
                    catch (Throwable throwable) {
                        block18: {
                            Object var9_14 = null;
                            if (this.unmanagedJicpData == null || this.unmanagedJicpData.hasRemaining()) break block18;
                            this.unmanagedJicpData = null;
                        }
                        throw throwable;
                    }
                    if (this.unmanagedJicpData != null && !this.unmanagedJicpData.hasRemaining()) {
                        this.unmanagedJicpData = null;
                    }
                    return jICPPacket;
                }
                JICPPacket jICPPacket = this.buildPacket(jicpData);
                Object var9_12 = null;
                if (this.unmanagedJicpData != null && !this.unmanagedJicpData.hasRemaining()) {
                    this.unmanagedJicpData = null;
                }
                return jICPPacket;
            }
            NIOHelper.copyAsMuchAsFits(this.payloadBuf, jicpData);
            if (this.payloadBuf.hasRemaining()) {
                throw new PacketIncompleteException("Missing " + this.payloadBuf.remaining() + " payload bytes");
            }
            JICPPacket jICPPacket = this.buildPacket(jicpData);
            Object var9_13 = null;
            if (this.unmanagedJicpData != null && !this.unmanagedJicpData.hasRemaining()) {
                this.unmanagedJicpData = null;
            }
            return jICPPacket;
        }
        throw new PacketIncompleteException(this.socketData.limit() + " bytes read from the network. No JICP data transformed");
    }

    public boolean moreDataAvailable() {
        return this.unmanagedJicpData != null;
    }

    private void read() throws IOException {
        this.socketData.clear();
        this.readFromChannel(this.socketData);
        while (!this.socketData.hasRemaining()) {
            this.socketData.flip();
            this.socketData = NIOHelper.enlargeAndFillBuffer(this.socketData, BEManagementService.getBufferIncreaseSize(), "socketData");
            try {
                this.readFromChannel(this.socketData);
            }
            catch (EOFException eofe) {
                // empty catch block
                break;
            }
        }
        this.socketData.flip();
        if (log.isLoggable(Level.FINE)) {
            log.fine("------- READ " + this.socketData.remaining() + " bytes from the network");
        }
    }

    private final int readFromChannel(ByteBuffer b) throws IOException {
        int n = this.myChannel.read(b);
        if (n == -1) {
            throw new EOFException("Channel closed");
        }
        return n;
    }

    private ByteBuffer transformAfterRead(ByteBuffer incomingData) throws IOException {
        ByteBuffer transformationInput;
        ByteBuffer transformationOutput = transformationInput = incomingData;
        ListIterator<BufferTransformerInfo> it = this.transformers.listIterator(this.transformers.size());
        while (it.hasPrevious()) {
            BufferTransformerInfo info = it.previous();
            BufferTransformer btf = info.getTransformer();
            transformationInput = info.attachUnprocessedData(transformationInput);
            if (log.isLoggable(Level.FINER)) {
                log.finer("--------- Passing " + transformationInput.remaining() + " bytes to Transformer " + btf.getClass().getName());
            }
            transformationOutput = btf.postprocessBufferRead(transformationInput);
            if (log.isLoggable(Level.FINER)) {
                log.finer("--------- Transformer " + btf.getClass().getName() + " did not transform " + transformationInput.remaining() + " bytes");
            }
            info.storeUnprocessedData(transformationInput);
            transformationInput = transformationOutput;
            if (transformationInput.hasRemaining() || !it.hasPrevious()) continue;
            break;
        }
        return transformationOutput;
    }

    private void resizePayloadBuffer(int payloadLength) {
        if (payloadLength > this.payloadBuf.capacity()) {
            this.payloadBuf = NIOHelper.enlargeBuffer(this.payloadBuf, payloadLength - this.payloadBuf.capacity(), "payLoad", true);
        } else {
            this.payloadBuf.limit(payloadLength);
        }
    }

    private JICPPacket buildPacket(ByteBuffer jicpData) {
        this.payloadBuf.flip();
        byte[] payload = new byte[this.payloadBuf.remaining()];
        this.payloadBuf.get(payload, 0, payload.length);
        JICPPacket pkt = new JICPPacket(this.type, this.info, this.recipientID, payload);
        pkt.setSessionID(this.sessionID);
        this.headerReceived = false;
        this.recipientID = null;
        this.payloadBuf.clear();
        if (jicpData.hasRemaining()) {
            this.unmanagedJicpData = jicpData;
        }
        return pkt;
    }

    public synchronized int writePacket(JICPPacket pkt) throws IOException {
        ByteBuffer bb = null;
        int totalToWrite = 0;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int n = pkt.writeTo(os);
        if (log.isLoggable(Level.FINE)) {
            log.fine("writePacket: number of bytes before preprocessing: " + n);
        }
        ByteBuffer toSend = ByteBuffer.wrap(os.toByteArray());
        bb = this.transformBeforeWrite(toSend);
        if (toSend.hasRemaining() && this.transformers.size() > 0) {
            throw new IOException("still need to transform: " + toSend.remaining());
        }
        int totalWrited = 0;
        totalToWrite = bb.remaining();
        while (bb.hasRemaining()) {
            int toWrite = bb.remaining();
            int writed = this.writeToChannel(bb);
            totalWrited += writed;
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine("writePacket: bytes written " + writed + ", needed to write: " + toWrite);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("writePacket: total bytes written " + totalWrited + ", total needed to write: " + totalToWrite);
        }
        return totalWrited;
    }

    private ByteBuffer transformBeforeWrite(ByteBuffer data) throws IOException {
        for (BufferTransformerInfo info : this.transformers) {
            BufferTransformer btf = info.getTransformer();
            data = btf.preprocessBufferToWrite(data);
        }
        return data;
    }

    public int writeToChannel(ByteBuffer bb) throws IOException {
        return this.myChannel.write(bb);
    }

    public void close() throws IOException {
        this.closed = true;
        this.myChannel.close();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public String getRemoteHost() {
        return this.myChannel.socket().getInetAddress().getHostAddress();
    }

    void init(SocketChannel channel) throws ICPException {
        this.myChannel = channel;
    }

    public void addBufferTransformer(BufferTransformer transformer) {
        this.transformers.add(new BufferTransformerInfo(transformer));
    }

    private class BufferTransformerInfo {
        private BufferTransformer transformer;
        private ByteBuffer unprocessedData;

        BufferTransformerInfo(BufferTransformer transformer) {
            this.transformer = transformer;
        }

        BufferTransformer getTransformer() {
            return this.transformer;
        }

        public void storeUnprocessedData(ByteBuffer transformationInput) {
            if (transformationInput.hasRemaining()) {
                this.unprocessedData = ByteBuffer.allocateDirect(transformationInput.remaining());
                NIOHelper.copyAsMuchAsFits(this.unprocessedData, transformationInput);
                this.unprocessedData.flip();
            } else {
                this.unprocessedData = null;
            }
        }

        public ByteBuffer attachUnprocessedData(ByteBuffer transformationInput) {
            ByteBuffer actualTransformationInput = transformationInput;
            if (this.unprocessedData != null && this.unprocessedData.hasRemaining()) {
                actualTransformationInput = NIOHelper.enlargeAndFillBuffer(this.unprocessedData, transformationInput.remaining(), "unprocessedData");
                NIOHelper.copyAsMuchAsFits(actualTransformationInput, transformationInput);
                actualTransformationInput.flip();
            }
            return actualTransformationInput;
        }
    }
}

