/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.plan;

import bdi4jade.core.PlanLibrary;
import bdi4jade.exception.PlanInstantiationException;
import bdi4jade.goal.Goal;
import bdi4jade.message.MessageGoal;
import bdi4jade.util.MetadataElement;
import jade.core.behaviours.Behaviour;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public abstract class Plan
extends MetadataElement {
    private final Set<Class<? extends Goal>> goals;
    protected final String id;
    private final Set<MessageTemplate> messageTemplates;
    private PlanLibrary planLibrary;

    public Plan(String id) {
        this(id, null, null);
    }

    public Plan(String id, Class<? extends Goal> goalClass) {
        this(id, goalClass, null);
    }

    public Plan(String id, Class<? extends Goal> goalClass, MessageTemplate messageTemplate) {
        if (id == null) {
            throw new RuntimeException("Plan id cannot be null.");
        }
        this.id = id;
        this.goals = new HashSet<Class<? extends Goal>>();
        if (goalClass != null) {
            this.goals.add(goalClass);
        }
        this.initGoals();
        this.messageTemplates = new HashSet<MessageTemplate>();
        if (messageTemplate != null) {
            this.messageTemplates.add(messageTemplate);
        }
        this.initMessageTemplates();
        this.putMetadata((Object)DefaultMetadata.CONTRIBUTIONS, new HashMap());
        this.putMetadata((Object)DefaultMetadata.DEPENDENCIES, new ArrayList());
    }

    public Plan(String id, MessageTemplate messageTemplate) {
        this(id, null, messageTemplate);
    }

    public void addGoal(Class<? extends Goal> goalClass) {
        this.goals.add(goalClass);
    }

    public void addMessageTemplate(MessageTemplate messageTemplate) {
        this.messageTemplates.add(messageTemplate);
    }

    public boolean canAchieve(Goal goal) {
        if (goal instanceof MessageGoal) {
            return this.canProcess(((MessageGoal)goal).getMessage());
        }
        return this.goals.contains(goal.getClass()) ? this.matchesContext(goal) : false;
    }

    public boolean canProcess(ACLMessage message) {
        for (MessageTemplate template : this.messageTemplates) {
            if (!template.match(message)) continue;
            return true;
        }
        return false;
    }

    public abstract Behaviour createPlanBody() throws PlanInstantiationException;

    public boolean equals(Object obj) {
        if (!(obj instanceof Plan)) {
            return false;
        }
        return this.id.equals(((Plan)obj).id);
    }

    public String getId() {
        return this.id;
    }

    public PlanLibrary getPlanLibrary() {
        return this.planLibrary;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    protected void initGoals() {
    }

    protected void initMessageTemplates() {
    }

    protected boolean matchesContext(Goal goal) {
        return true;
    }

    public void setPlanLibrary(PlanLibrary planLibrary) {
        this.planLibrary = planLibrary;
    }

    public String toString() {
        return this.id;
    }

    public static enum DefaultMetadata {
        CONTRIBUTIONS,
        DEPENDENCIES;

    }
}

