/*
 * Decompiled with CFR 0.152.
 */
package jade.core.messaging;

import jade.core.AID;
import jade.core.ContainerID;
import jade.core.GenericCommand;
import jade.core.IMTPException;
import jade.core.Node;
import jade.core.NotFoundException;
import jade.core.ServiceException;
import jade.core.SliceProxy;
import jade.core.messaging.GenericMessage;
import jade.core.messaging.MessagingSlice;
import jade.domain.FIPAAgentManagement.Envelope;
import jade.mtp.MTPDescriptor;
import jade.mtp.MTPException;
import jade.security.JADESecurityException;
import jade.util.leap.List;
import java.util.Hashtable;

public class MessagingProxy
extends SliceProxy
implements MessagingSlice {
    public void dispatchLocally(AID senderID, GenericMessage msg, AID receiverID) throws IMTPException, NotFoundException, JADESecurityException {
        try {
            GenericCommand cmd = new GenericCommand("1", "jade.core.messaging.Messaging", null);
            cmd.addParam(senderID);
            cmd.addParam(msg);
            cmd.addParam(receiverID);
            long timeStamp = msg.getTimeStamp();
            if (timeStamp > 0L) {
                cmd.addParam(new Long(timeStamp));
            }
            cmd.setPrincipal(msg.getSenderPrincipal());
            cmd.setCredentials(msg.getSenderCredentials());
            Node n = this.getNode();
            Object result = n.accept(cmd);
            if (result != null && result instanceof Throwable) {
                if (result instanceof IMTPException) {
                    throw (IMTPException)result;
                }
                if (result instanceof NotFoundException) {
                    throw (NotFoundException)result;
                }
                if (result instanceof JADESecurityException) {
                    throw (JADESecurityException)result;
                }
                throw new IMTPException("An undeclared exception was thrown", (Throwable)result);
            }
        }
        catch (ServiceException se) {
            throw new IMTPException("Unable to access remote node", se);
        }
    }

    public void routeOut(Envelope env, byte[] payload, AID receiverID, String address) throws IMTPException, MTPException {
        try {
            GenericCommand cmd = new GenericCommand("2", "jade.core.messaging.Messaging", null);
            cmd.addParam(env);
            cmd.addParam(payload);
            cmd.addParam(receiverID);
            cmd.addParam(address);
            Node n = this.getNode();
            Object result = n.accept(cmd);
            if (result != null && result instanceof Throwable) {
                if (result instanceof IMTPException) {
                    throw (IMTPException)result;
                }
                if (result instanceof MTPException) {
                    throw (MTPException)result;
                }
                throw new IMTPException("An undeclared exception was thrown", (Throwable)result);
            }
        }
        catch (ServiceException se) {
            throw new IMTPException("Unable to access remote node", se);
        }
    }

    public ContainerID getAgentLocation(AID agentID) throws IMTPException, NotFoundException {
        try {
            GenericCommand cmd = new GenericCommand("3", "jade.core.messaging.Messaging", null);
            cmd.addParam(agentID);
            Node n = this.getNode();
            Object result = n.accept(cmd);
            if (result != null && result instanceof Throwable) {
                if (result instanceof IMTPException) {
                    throw (IMTPException)result;
                }
                if (result instanceof NotFoundException) {
                    throw (NotFoundException)result;
                }
                throw new IMTPException("An undeclared exception was thrown", (Throwable)result);
            }
            return (ContainerID)result;
        }
        catch (ServiceException se) {
            throw new IMTPException("Unable to access remote node", se);
        }
    }

    public MTPDescriptor installMTP(String address, String className) throws IMTPException, ServiceException, MTPException {
        try {
            GenericCommand cmd = new GenericCommand("4", "jade.core.messaging.Messaging", null);
            cmd.addParam(address);
            cmd.addParam(className);
            Node n = this.getNode();
            Object result = n.accept(cmd);
            if (result != null && result instanceof Throwable) {
                if (result instanceof IMTPException) {
                    throw (IMTPException)result;
                }
                if (result instanceof MTPException) {
                    throw (MTPException)result;
                }
                if (result instanceof ServiceException) {
                    throw (ServiceException)result;
                }
                throw new IMTPException("An undeclared exception was thrown", (Throwable)result);
            }
            return (MTPDescriptor)result;
        }
        catch (ServiceException se) {
            throw new IMTPException("Unable to access remote node", se);
        }
    }

    public void uninstallMTP(String address) throws IMTPException, ServiceException, NotFoundException, MTPException {
        try {
            GenericCommand cmd = new GenericCommand("5", "jade.core.messaging.Messaging", null);
            cmd.addParam(address);
            Node n = this.getNode();
            Object result = n.accept(cmd);
            if (result != null && result instanceof Throwable) {
                if (result instanceof IMTPException) {
                    throw (IMTPException)result;
                }
                if (result instanceof NotFoundException) {
                    throw (NotFoundException)result;
                }
                if (result instanceof ServiceException) {
                    throw (ServiceException)result;
                }
                throw new IMTPException("An undeclared exception was thrown", (Throwable)result);
            }
        }
        catch (ServiceException se) {
            throw new IMTPException("Unable to access remote node", se);
        }
    }

    public void newMTP(MTPDescriptor mtp, ContainerID cid) throws IMTPException, ServiceException {
        try {
            GenericCommand cmd = new GenericCommand("6", "jade.core.messaging.Messaging", null);
            cmd.addParam(mtp);
            cmd.addParam(cid);
            Node n = this.getNode();
            Object result = n.accept(cmd);
            if (result != null && result instanceof Throwable) {
                if (result instanceof IMTPException) {
                    throw (IMTPException)result;
                }
                if (result instanceof ServiceException) {
                    throw (ServiceException)result;
                }
                throw new IMTPException("An undeclared exception was thrown", (Throwable)result);
            }
        }
        catch (ServiceException se) {
            throw new IMTPException("Unable to access remote node", se);
        }
    }

    public void deadMTP(MTPDescriptor mtp, ContainerID cid) throws IMTPException, ServiceException {
        try {
            GenericCommand cmd = new GenericCommand("7", "jade.core.messaging.Messaging", null);
            cmd.addParam(mtp);
            cmd.addParam(cid);
            Node n = this.getNode();
            Object result = n.accept(cmd);
            if (result != null && result instanceof Throwable) {
                if (result instanceof IMTPException) {
                    throw (IMTPException)result;
                }
                if (result instanceof ServiceException) {
                    throw (ServiceException)result;
                }
                throw new IMTPException("An undeclared exception was thrown", (Throwable)result);
            }
        }
        catch (ServiceException se) {
            throw new IMTPException("Unable to access remote node", se);
        }
    }

    public void addRoute(MTPDescriptor mtp, String sliceName) throws IMTPException, ServiceException {
        try {
            GenericCommand cmd = new GenericCommand("8", "jade.core.messaging.Messaging", null);
            cmd.addParam(mtp);
            cmd.addParam(sliceName);
            Node n = this.getNode();
            Object result = n.accept(cmd);
            if (result != null && result instanceof Throwable) {
                if (result instanceof IMTPException) {
                    throw (IMTPException)result;
                }
                if (result instanceof ServiceException) {
                    throw (ServiceException)result;
                }
                throw new IMTPException("An undeclared exception was thrown", (Throwable)result);
            }
        }
        catch (ServiceException se) {
            throw new IMTPException("Unable to access remote node", se);
        }
    }

    public void removeRoute(MTPDescriptor mtp, String sliceName) throws IMTPException, ServiceException {
        try {
            GenericCommand cmd = new GenericCommand("9", "jade.core.messaging.Messaging", null);
            cmd.addParam(mtp);
            cmd.addParam(sliceName);
            Node n = this.getNode();
            Object result = n.accept(cmd);
            if (result != null && result instanceof Throwable) {
                if (result instanceof IMTPException) {
                    throw (IMTPException)result;
                }
                if (result instanceof ServiceException) {
                    throw (ServiceException)result;
                }
                throw new IMTPException("An undeclared exception was thrown", (Throwable)result);
            }
        }
        catch (ServiceException se) {
            throw new IMTPException("Unable to access remote node", se);
        }
    }

    public void newAlias(AID alias, AID agent) throws IMTPException {
        try {
            GenericCommand cmd = new GenericCommand("10", "jade.core.messaging.Messaging", null);
            cmd.addParam(alias);
            cmd.addParam(agent);
            Node n = this.getNode();
            Object result = n.accept(cmd);
            if (result != null && result instanceof Throwable) {
                if (result instanceof IMTPException) {
                    throw (IMTPException)result;
                }
                throw new IMTPException("An undeclared exception was thrown", (Throwable)result);
            }
        }
        catch (ServiceException se) {
            throw new IMTPException("Unable to access remote node stub", se);
        }
    }

    public void deadAlias(AID alias) throws IMTPException {
        try {
            GenericCommand cmd = new GenericCommand("11", "jade.core.messaging.Messaging", null);
            cmd.addParam(alias);
            Node n = this.getNode();
            Object result = n.accept(cmd);
            if (result != null && result instanceof Throwable) {
                if (result instanceof IMTPException) {
                    throw (IMTPException)result;
                }
                throw new IMTPException("An undeclared exception was thrown", (Throwable)result);
            }
        }
        catch (ServiceException se) {
            throw new IMTPException("Unable to access remote node stub", se);
        }
    }

    public void currentAliases(Hashtable aliases) throws IMTPException {
        try {
            GenericCommand cmd = new GenericCommand("12", "jade.core.messaging.Messaging", null);
            cmd.addParam(aliases);
            Node n = this.getNode();
            Object result = n.accept(cmd);
            if (result != null && result instanceof Throwable) {
                if (result instanceof IMTPException) {
                    throw (IMTPException)result;
                }
                throw new IMTPException("An undeclared exception was thrown", (Throwable)result);
            }
        }
        catch (ServiceException se) {
            throw new IMTPException("Unable to access remote node stub", se);
        }
    }

    public void transferLocalAliases(AID agent, List aliases) throws IMTPException {
        try {
            GenericCommand cmd = new GenericCommand("13", "jade.core.messaging.Messaging", null);
            cmd.addParam(agent);
            cmd.addParam(aliases);
            Node n = this.getNode();
            Object result = n.accept(cmd);
            if (result != null && result instanceof Throwable) {
                if (result instanceof IMTPException) {
                    throw (IMTPException)result;
                }
                throw new IMTPException("An undeclared exception was thrown", (Throwable)result);
            }
        }
        catch (ServiceException se) {
            throw new IMTPException("Unable to access remote node stub", se);
        }
    }
}

