/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.core;

import bdi4jade.belief.Belief;
import bdi4jade.core.Capability;
import bdi4jade.event.BeliefEvent;
import bdi4jade.event.BeliefListener;
import bdi4jade.exception.BeliefAlreadyExistsException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BeliefBase
implements Serializable {
    private static final long serialVersionUID = -6411530721625492882L;
    private final Set<BeliefListener> beliefListeners = new HashSet<BeliefListener>();
    private final Map<String, Belief<?>> beliefs = new HashMap();
    private Capability capability = null;

    public BeliefBase() {
        this(null);
    }

    public BeliefBase(Set<Belief<?>> beliefs) {
        if (beliefs != null) {
            for (Belief<?> belief : beliefs) {
                this.addBelief(belief);
            }
        }
    }

    public void addBelief(Belief<?> belief) {
        if (this.hasBelief(belief.getName())) {
            throw new BeliefAlreadyExistsException(belief);
        }
        belief.addBeliefBase(this);
        this.beliefs.put(belief.getName(), belief);
        this.notifyBeliefChanged(new BeliefEvent(belief, BeliefEvent.Action.BELIEF_ADDED));
    }

    public void addBeliefListener(BeliefListener beliefListener) {
        this.beliefListeners.add(beliefListener);
    }

    public void addOrUpdateBelief(Belief<?> belief) {
        if (this.hasBelief(belief.getName())) {
            this.updateBelief(belief.getName(), belief.getValue());
        } else {
            this.addBelief(belief);
        }
    }

    public Collection<Belief<?>> getAllBeliefs() {
        LinkedList beliefs = new LinkedList();
        this.getAllBeliefs(beliefs);
        return beliefs;
    }

    private void getAllBeliefs(Collection<Belief<?>> beliefs) {
        beliefs.addAll(this.beliefs.values());
        if (this.capability != null && this.capability.getParent() != null) {
            this.capability.getParent().getBeliefBase().getAllBeliefs(beliefs);
        }
    }

    public Belief<?> getBelief(String name) {
        Belief<?> belief = this.beliefs.get(name);
        if (belief == null && this.capability != null && this.capability.getParent() != null) {
            belief = this.capability.getParent().getBeliefBase().getBelief(name);
        }
        return belief;
    }

    public Set<BeliefListener> getBeliefListeners() {
        return this.beliefListeners;
    }

    public Set<Belief<?>> getBeliefs() {
        HashSet beliefValues = new HashSet(this.beliefs.size());
        for (Belief<?> belief : this.beliefs.values()) {
            beliefValues.add(belief);
        }
        return beliefValues;
    }

    public List<Object> getBeliefValues() {
        ArrayList<Object> beliefValues = new ArrayList<Object>(this.beliefs.size());
        for (Belief<?> belief : this.beliefs.values()) {
            beliefValues.add(belief.getValue());
        }
        return beliefValues;
    }

    public Capability getCapability() {
        return this.capability;
    }

    public boolean hasBelief(String name) {
        boolean hasBelief = this.beliefs.containsKey(name);
        if (!hasBelief && this.capability != null && this.capability.getParent() != null) {
            hasBelief = this.capability.getParent().getBeliefBase().hasBelief(name);
        }
        return hasBelief;
    }

    protected void init() {
    }

    private void notifyBeliefChanged(BeliefEvent beliefChanged) {
        for (BeliefListener beliefListener : this.beliefListeners) {
            beliefListener.update(beliefChanged);
        }
        if (this.capability != null) {
            for (Capability child : this.capability.getChildren()) {
                child.getBeliefBase().notifyBeliefChanged(beliefChanged);
            }
        }
    }

    public Belief<?> removeBelief(String name) {
        Belief<?> belief = this.beliefs.remove(name);
        if (belief != null) {
            belief.removeBeliefBase(this);
            this.notifyBeliefChanged(new BeliefEvent(belief, BeliefEvent.Action.BELIEF_REMOVED));
        } else if (this.capability != null && this.capability.getParent() != null) {
            belief = this.capability.getParent().getBeliefBase().removeBelief(name);
        }
        return belief;
    }

    public void removeBeliefListener(BeliefListener beliefListener) {
        this.beliefListeners.remove(beliefListener);
    }

    public void reviewBeliefs() {
    }

    public void setCapability(Capability capability) {
        if (this.capability != null) {
            throw new RuntimeException("BeliefBase already binded to another capability!");
        }
        this.capability = capability;
        this.init();
    }

    public int size() {
        return this.beliefs.size();
    }

    public String toString() {
        return new StringBuffer("BeliefBase = ").append(this.getBeliefs()).toString();
    }

    public boolean updateBelief(String name, Object value) {
        Belief<?> belief = this.beliefs.get(name);
        if (belief != null) {
            Object oldValue = belief.getValue();
            belief.setValue(value);
            this.notifyBeliefChanged(new BeliefEvent(belief, BeliefEvent.Action.BELIEF_UPDATED, oldValue));
            return true;
        }
        if (this.capability != null && this.capability.getParent() != null) {
            return this.capability.getParent().getBeliefBase().updateBelief(name, value);
        }
        return false;
    }
}

