/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.core;

import bdi4jade.core.BDIAgent;
import bdi4jade.core.BeliefBase;
import bdi4jade.core.PlanLibrary;
import jade.lang.acl.ACLMessage;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class Capability
implements Serializable {
    private static final long serialVersionUID = -4922359927943108421L;
    protected final BeliefBase beliefBase;
    protected final Set<Capability> children;
    protected final String id;
    protected BDIAgent myAgent;
    protected Capability parent;
    protected final PlanLibrary planLibrary;
    private boolean start;

    public Capability() {
        this(null);
    }

    public Capability(BeliefBase beliefBase, PlanLibrary planLibrary) {
        this(null, beliefBase, planLibrary);
    }

    public Capability(String id) {
        this(id, new BeliefBase(), new PlanLibrary());
    }

    public Capability(String id, BeliefBase beliefBase, PlanLibrary planLibrary) {
        this(id, null, beliefBase, planLibrary);
    }

    public Capability(String id, Capability parent) {
        this(id, parent, new BeliefBase(), new PlanLibrary());
    }

    public Capability(String id, Capability parent, BeliefBase beliefBase, PlanLibrary planLibrary) {
        this.id = id == null ? (this.getClass().getCanonicalName() == null || Capability.class.equals(this.getClass()) ? String.valueOf(Capability.class.getSimpleName()) + System.currentTimeMillis() : this.getClass().getSimpleName()) : id;
        this.children = new HashSet<Capability>();
        if (parent != null) {
            parent.addChild(this);
        }
        beliefBase.setCapability(this);
        this.beliefBase = beliefBase;
        planLibrary.setCapability(this);
        this.planLibrary = planLibrary;
        this.start = false;
    }

    public void addChild(Capability capability) {
        if (capability.parent != null) {
            capability.parent.removeChild(capability);
        }
        capability.parent = this;
        this.children.add(capability);
    }

    public boolean canProcess(ACLMessage msg) {
        return this.planLibrary.canProcessPlans(msg);
    }

    public BeliefBase getBeliefBase() {
        return this.beliefBase;
    }

    public Set<Capability> getChildren() {
        return new HashSet<Capability>(this.children);
    }

    public String getId() {
        return this.id;
    }

    public BDIAgent getMyAgent() {
        return this.myAgent;
    }

    public Capability getParent() {
        return this.parent;
    }

    public PlanLibrary getPlanLibrary() {
        return this.planLibrary;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public boolean removeChild(Capability capability) {
        boolean removed = this.children.remove(capability);
        if (removed) {
            capability.parent = null;
        }
        return removed;
    }

    public void setMyAgent(BDIAgent myAgent) {
        this.myAgent = myAgent;
        if (!this.start) {
            this.setup();
            this.start = true;
        }
    }

    protected void setup() {
    }

    public String toString() {
        return this.id;
    }
}

