/*
 * Decompiled with CFR 0.152.
 */
package jade.content.lang.sl;

import jade.content.abs.AbsAgentAction;
import jade.content.abs.AbsPredicate;
import jade.content.lang.sl.SL1Ontology;
import jade.content.lang.sl.SL2Vocabulary;
import jade.content.onto.Introspector;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.schema.AgentActionSchema;
import jade.content.schema.ConceptSchema;
import jade.content.schema.IRESchema;
import jade.content.schema.PredicateSchema;
import jade.content.schema.VariableSchema;
import jade.core.CaseInsensitiveString;

class SL2Ontology
extends SL1Ontology
implements SL2Vocabulary {
    public static final String ONTOLOGY_NAME = "SL2-ONTOLOGY";
    private static Ontology theInstance = new SL2Ontology("SL2-ONTOLOGY", SL1Ontology.getInstance(), null);

    public static Ontology getInstance() {
        return theInstance;
    }

    protected SL2Ontology(String name, Ontology base, Introspector intro) {
        super(name, base, intro);
        try {
            this.add(new PredicateSchema("implies"), AbsPredicate.getJavaClass());
            this.add(new PredicateSchema("equiv"), AbsPredicate.getJavaClass());
            PredicateSchema ps = (PredicateSchema)this.getSchema("implies");
            ps.add("left", (PredicateSchema)PredicateSchema.getBaseSchema());
            ps.add("right", (PredicateSchema)PredicateSchema.getBaseSchema());
            ps = (PredicateSchema)this.getSchema("equiv");
            ps.add("left", (PredicateSchema)PredicateSchema.getBaseSchema());
            ps.add("right", (PredicateSchema)PredicateSchema.getBaseSchema());
            this.add(VariableSchema.getBaseSchema());
            this.add(new IRESchema("iota"));
            this.add(new IRESchema("any"));
            this.add(new IRESchema("all"));
            this.add(new PredicateSchema("forall"), AbsPredicate.getJavaClass());
            this.add(new PredicateSchema("exists"), AbsPredicate.getJavaClass());
            this.add(new PredicateSchema("B"), AbsPredicate.getJavaClass());
            this.add(new PredicateSchema("U"), AbsPredicate.getJavaClass());
            this.add(new PredicateSchema("PG"), AbsPredicate.getJavaClass());
            this.add(new PredicateSchema("I"), AbsPredicate.getJavaClass());
            this.add(new PredicateSchema("feasible"), AbsPredicate.getJavaClass());
            this.add(new AgentActionSchema(";"), AbsAgentAction.getJavaClass());
            this.add(new AgentActionSchema("|"), AbsAgentAction.getJavaClass());
            ps = (PredicateSchema)this.getSchema("exists");
            ps.add("what", (VariableSchema)VariableSchema.getBaseSchema());
            ps.add("condition", (PredicateSchema)PredicateSchema.getBaseSchema());
            ps = (PredicateSchema)this.getSchema("forall");
            ps.add("what", (VariableSchema)VariableSchema.getBaseSchema());
            ps.add("condition", (PredicateSchema)PredicateSchema.getBaseSchema());
            ps = (PredicateSchema)this.getSchema("B");
            ps.add("agent", (ConceptSchema)this.getSchema("agent-identifier"));
            ps.add("condition", (PredicateSchema)PredicateSchema.getBaseSchema());
            ps = (PredicateSchema)this.getSchema("U");
            ps.add("agent", (ConceptSchema)this.getSchema("agent-identifier"));
            ps.add("condition", (PredicateSchema)PredicateSchema.getBaseSchema());
            ps = (PredicateSchema)this.getSchema("PG");
            ps.add("agent", (ConceptSchema)this.getSchema("agent-identifier"));
            ps.add("condition", (PredicateSchema)PredicateSchema.getBaseSchema());
            ps = (PredicateSchema)this.getSchema("I");
            ps.add("agent", (ConceptSchema)this.getSchema("agent-identifier"));
            ps.add("condition", (PredicateSchema)PredicateSchema.getBaseSchema());
            ps = (PredicateSchema)this.getSchema("feasible");
            ps.add("action", (VariableSchema)VariableSchema.getBaseSchema());
            ps.add("condition", (PredicateSchema)PredicateSchema.getBaseSchema(), 1);
            AgentActionSchema as = (AgentActionSchema)this.getSchema(";");
            as.add("first", (AgentActionSchema)AgentActionSchema.getBaseSchema());
            as.add("second", (AgentActionSchema)AgentActionSchema.getBaseSchema());
            as.setEncodingByOrder(true);
            as = (AgentActionSchema)this.getSchema("|");
            as.add("first", (AgentActionSchema)AgentActionSchema.getBaseSchema());
            as.add("second", (AgentActionSchema)AgentActionSchema.getBaseSchema());
            as.setEncodingByOrder(true);
        }
        catch (OntologyException oe) {
            oe.printStackTrace();
        }
    }

    boolean isQuantifier(String symbol) {
        return CaseInsensitiveString.equalsIgnoreCase("exists", symbol) || CaseInsensitiveString.equalsIgnoreCase("forall", symbol);
    }

    boolean isModalOp(String symbol) {
        return CaseInsensitiveString.equalsIgnoreCase("B", symbol) || CaseInsensitiveString.equalsIgnoreCase("U", symbol) || CaseInsensitiveString.equalsIgnoreCase("PG", symbol) || CaseInsensitiveString.equalsIgnoreCase("I", symbol);
    }

    boolean isActionOp(String symbol) {
        return super.isActionOp(symbol) || CaseInsensitiveString.equalsIgnoreCase("feasible", symbol);
    }

    boolean isSLFunctionWithoutSlotNames(String symbol) {
        return super.isSLFunctionWithoutSlotNames(symbol) || CaseInsensitiveString.equalsIgnoreCase(";", symbol) || CaseInsensitiveString.equalsIgnoreCase("|", symbol);
    }

    boolean isBinaryLogicalOp(String symbol) {
        return super.isBinaryLogicalOp(symbol) || CaseInsensitiveString.equalsIgnoreCase("implies", symbol) || CaseInsensitiveString.equalsIgnoreCase("equiv", symbol);
    }
}

