/*
 * Decompiled with CFR 0.152.
 */
package jade.core.behaviours;

import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.util.leap.Serializable;

public final class ReceiverBehaviour
extends Behaviour {
    private MessageTemplate template;
    private MessageFuture future;
    private long timeOut;
    private long timeToWait;
    private long blockingTime = 0L;
    private boolean finished;

    public static Handle newHandle() {
        return new MessageFuture();
    }

    public ReceiverBehaviour(Agent a, long millis, MessageTemplate mt) {
        this(a, ReceiverBehaviour.newHandle(), millis, mt);
    }

    public ReceiverBehaviour(Agent a, Handle h, long millis) {
        this(a, h, millis, null);
    }

    public ReceiverBehaviour(Agent a, Handle h, long millis, MessageTemplate mt) {
        super(a);
        this.future = (MessageFuture)h;
        this.timeToWait = this.timeOut = millis;
        this.template = mt;
    }

    public void action() {
        ACLMessage msg = null;
        msg = this.template == null ? this.myAgent.receive() : this.myAgent.receive(this.template);
        if (msg == null) {
            if (this.timeOut < 0L) {
                this.block();
                this.finished = false;
                return;
            }
            long elapsedTime = 0L;
            elapsedTime = this.blockingTime != 0L ? System.currentTimeMillis() - this.blockingTime : 0L;
            this.timeToWait -= elapsedTime;
            if (this.timeToWait > 0L) {
                this.blockingTime = System.currentTimeMillis();
                this.block(this.timeToWait);
                return;
            }
            this.future.setMessage(msg);
            this.finished = true;
        } else {
            this.future.setMessage(msg);
            this.finished = true;
        }
    }

    public boolean done() {
        return this.finished;
    }

    public void reset() {
        this.finished = false;
        this.future.reset();
        this.timeToWait = this.timeOut;
        this.blockingTime = 0L;
        super.reset();
    }

    public ACLMessage getMessage() throws TimedOut, NotYetReady {
        return this.future.getMessage();
    }

    private static class MessageFuture
    implements Handle,
    Serializable {
        private static final int OK = 0;
        private static final int NOT_YET = 1;
        private static final int TIMED_OUT = 2;
        private int state = 1;
        private ACLMessage message;

        private MessageFuture() {
        }

        public void reset() {
            this.message = null;
            this.state = 1;
        }

        public void setMessage(ACLMessage msg) {
            this.message = msg;
            this.state = this.message != null ? 0 : 2;
        }

        public ACLMessage getMessage() throws TimedOut, NotYetReady {
            switch (this.state) {
                case 1: {
                    throw new NotYetReady();
                }
                case 2: {
                    throw new TimedOut();
                }
            }
            return this.message;
        }
    }

    public static interface Handle {
        public ACLMessage getMessage() throws TimedOut, NotYetReady;
    }

    public static class NotYetReady
    extends Exception {
        NotYetReady() {
            super("Requested message is not ready yet.");
        }
    }

    public static class TimedOut
    extends Exception {
        TimedOut() {
            super("No message was received before time limit.");
        }
    }
}

