/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.belief;

import bdi4jade.core.BeliefBase;
import bdi4jade.util.MetadataElement;
import jade.content.Concept;
import java.io.Serializable;
import java.security.InvalidParameterException;
import java.util.HashSet;
import java.util.Set;

public abstract class Belief<T>
extends MetadataElement
implements Serializable,
Concept {
    private static final long serialVersionUID = 5098122115249071355L;
    private final Set<BeliefBase> beliefBases;
    protected final String name;

    public Belief(String name) {
        if (name == null) {
            throw new InvalidParameterException("Belief name must be not null.");
        }
        this.name = name;
        this.beliefBases = new HashSet<BeliefBase>();
    }

    public Belief(String name, T value) {
        this(name);
        this.setValue(value);
    }

    public void addBeliefBase(BeliefBase beliefBase) {
        this.beliefBases.add(beliefBase);
    }

    public final boolean equals(Object obj) {
        if (obj instanceof Belief) {
            Belief b = (Belief)obj;
            return this.name.equals(b.getName());
        }
        return false;
    }

    public Set<BeliefBase> getBeliefBases() {
        return this.beliefBases;
    }

    public final String getName() {
        return this.name;
    }

    public abstract T getValue();

    public int hashCode() {
        return this.name.hashCode();
    }

    public void removeBeliefBase(BeliefBase beliefBases) {
        this.beliefBases.remove(beliefBases);
    }

    public abstract void setValue(T var1);

    public String toString() {
        return new StringBuffer(this.name).append(" = ").append(this.getValue()).toString();
    }
}

