/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.plan;

import bdi4jade.core.BeliefBase;
import bdi4jade.core.Intention;
import bdi4jade.event.GoalEvent;
import bdi4jade.event.GoalFinishedEvent;
import bdi4jade.event.GoalListener;
import bdi4jade.exception.PlanInstantiationException;
import bdi4jade.goal.Goal;
import bdi4jade.plan.DisposablePlanBody;
import bdi4jade.plan.OutputPlanBody;
import bdi4jade.plan.Plan;
import bdi4jade.plan.PlanBody;
import jade.core.behaviours.Behaviour;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class PlanInstance
implements GoalListener {
    private final Behaviour behaviour;
    private EndState endState;
    private final List<GoalFinishedEvent> goalEventQueue;
    private final Intention intention;
    private final Plan plan;
    private final List<Goal> subgoals;

    public PlanInstance(Plan plan, Intention intention) throws PlanInstantiationException {
        this.plan = plan;
        this.intention = intention;
        this.subgoals = new ArrayList<Goal>();
        this.behaviour = plan.createPlanBody();
        if (!(this.behaviour instanceof PlanBody)) {
            throw new PlanInstantiationException("instantiateBehavior() does not return a behaviour that implements PlanBody");
        }
        PlanBody planBody = (PlanBody)this.behaviour;
        planBody.init(this);
        this.endState = null;
        this.goalEventQueue = new LinkedList<GoalFinishedEvent>();
    }

    public void dispatchProtectedGoal(Goal goal) {
        this.intention.getMyAgent().addGoal(this.plan.getPlanLibrary().getCapability(), goal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchProtectedSubgoal(Goal subgoal) {
        this.intention.getMyAgent().addGoal(this.plan.getPlanLibrary().getCapability(), subgoal);
        List<Goal> list = this.subgoals;
        synchronized (list) {
            this.subgoals.add(subgoal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchProtectedSubgoalAndListen(Goal subgoal) {
        this.intention.getMyAgent().addGoal(this.plan.getPlanLibrary().getCapability(), subgoal, this);
        List<Goal> list = this.subgoals;
        synchronized (list) {
            this.subgoals.add(subgoal);
        }
    }

    public void dispatchGoal(Goal goal) {
        this.intention.getMyAgent().addGoal(goal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchSubgoal(Goal subgoal) {
        this.intention.getMyAgent().addGoal(subgoal);
        List<Goal> list = this.subgoals;
        synchronized (list) {
            this.subgoals.add(subgoal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchSubgoalAndListen(Goal subgoal) {
        this.intention.getMyAgent().addGoal(subgoal, this);
        List<Goal> list = this.subgoals;
        synchronized (list) {
            this.subgoals.add(subgoal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropSubgoals() {
        List<Goal> list = this.subgoals;
        synchronized (list) {
            Iterator<Goal> it = this.subgoals.iterator();
            while (it.hasNext()) {
                Goal subgoal = it.next();
                this.intention.getMyAgent().setNoLongerDesired(subgoal);
                it.remove();
            }
        }
    }

    public BeliefBase getBeliefBase() {
        return this.plan.getPlanLibrary().getCapability().getBeliefBase();
    }

    public EndState getEndState() {
        if (this.endState == null) {
            this.endState = ((PlanBody)this.behaviour).getEndState();
            if (this.endState != null) {
                if (this.behaviour instanceof OutputPlanBody) {
                    ((OutputPlanBody)this.behaviour).setGoalOutput(this.getGoal());
                }
                if (EndState.FAILED.equals((Object)this.endState)) {
                    this.dropSubgoals();
                }
            }
        }
        return this.endState;
    }

    public Goal getGoal() {
        return this.intention.getGoal();
    }

    public GoalFinishedEvent getGoalEvent() {
        return this.getGoalEvent(true, -1L);
    }

    public GoalFinishedEvent getGoalEvent(boolean block) {
        return this.getGoalEvent(block, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GoalFinishedEvent getGoalEvent(boolean block, long ms) {
        List<GoalFinishedEvent> list = this.goalEventQueue;
        synchronized (list) {
            if (!this.goalEventQueue.isEmpty()) {
                return this.goalEventQueue.remove(0);
            }
            if (this.behaviour != null && block) {
                if (ms < 0L) {
                    this.behaviour.block();
                } else {
                    this.behaviour.block(ms);
                }
            }
            return null;
        }
    }

    public GoalFinishedEvent getGoalEvent(long ms) {
        return this.getGoalEvent(true, ms);
    }

    public Plan getPlan() {
        return this.plan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void goalPerformed(GoalEvent event) {
        if (event instanceof GoalFinishedEvent) {
            List<Object> list = this.goalEventQueue;
            synchronized (list) {
                this.goalEventQueue.add((GoalFinishedEvent)event);
                if (this.behaviour != null) {
                    this.behaviour.restart();
                }
            }
            list = this.subgoals;
            synchronized (list) {
                this.subgoals.remove(event.getGoal());
            }
        }
    }

    public void startPlan() {
        this.intention.getMyAgent().addBehaviour(this.behaviour);
    }

    public void stopPlan() {
        this.dropSubgoals();
        this.intention.getMyAgent().removeBehaviour(this.behaviour);
        if (this.behaviour instanceof DisposablePlanBody) {
            ((DisposablePlanBody)this.behaviour).onAbort();
        }
    }

    public static enum EndState {
        FAILED,
        SUCCESSFUL;

    }
}

