/*
 * Decompiled with CFR 0.152.
 */
package jade;

import jade.BootHelper;
import jade.core.ProfileImpl;
import jade.core.Specifier;
import jade.util.ExtendedProperties;
import jade.util.PropertiesException;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import jade.util.leap.Properties;
import java.util.Enumeration;
import java.util.Vector;

public class BootProfileImpl
extends ProfileImpl {
    public static final String ACLCODEC_KEY = "aclcodec";
    public static final String CONF_KEY = "conf";
    public static final String CONTAINER_KEY = "container";
    public static final String DUMP_KEY = "dump";
    public static final String GUI_KEY = "gui";
    public static final String HELP_KEY = "help";
    public static final String MTP_KEY = "mtp";
    public static final String NOMTP_KEY = "nomtp";
    public static final String NAME_KEY = "name";
    public static final String LOGIN_KEY = "auth";
    public static final String SMHOST_KEY = "smhost";
    public static final String SMPORT_KEY = "smport";
    public static final String VERSION_KEY = "version";
    public static final String NOMOBILITY_KEY = "nomobility";
    ExtendedProperties argProp = null;
    BootHelper helper = new BootHelper();
    private static final String ARGUMENT_SEPARATOR = ";";

    public BootProfileImpl() {
        super(true);
        this.argProp = new ExtendedProperties();
    }

    public BootProfileImpl(String[] args) throws PropertiesException {
        this();
        ExtendedProperties properties = new ExtendedProperties(args);
        this.bootProps = (Properties)properties.clone();
        this.setArgProperties(properties);
    }

    public ExtendedProperties getArgProperties() {
        return this.argProp;
    }

    public void setArgProperties(ExtendedProperties source) {
        Enumeration e;
        String host;
        this.argProp.copyProperties(source);
        String value = null;
        boolean flag = false;
        ExtendedProperties profileProp = (ExtendedProperties)this.getProperties();
        boolean isMain = true;
        if (this.argProp.getProperty("main") != null) {
            isMain = this.fetchAndVerifyBoolean("main");
        } else {
            boolean bl = isMain = !this.fetchAndVerifyBoolean(CONTAINER_KEY);
        }
        if (isMain) {
            profileProp.setProperty("main", "true");
        } else {
            profileProp.setProperty("main", "false");
            this.setSpecifiers("mtps", new ArrayList(0));
        }
        String sm = this.argProp.getProperty("backupmain");
        if (sm != null) {
            profileProp.setProperty("backupmain", sm);
        }
        if ((value = this.argProp.getProperty("imtp")) != null) {
            profileProp.setProperty("imtp", value);
        }
        if ((host = this.argProp.getProperty("host")) != null) {
            profileProp.setProperty("host", host);
        } else {
            host = profileProp.getProperty("host");
            if (host == null) {
                host = BootProfileImpl.getDefaultNetworkName();
                profileProp.setProperty("host", host);
            }
        }
        String port = this.argProp.getProperty("port");
        if (port == null) {
            if (this.isMasterMain()) {
                port = this.argProp.getProperty("local-port");
            }
            if (port == null) {
                port = Integer.toString(1099);
            }
        }
        profileProp.setProperty("port", port);
        String localHost = this.argProp.getProperty("local-host");
        if (localHost == null) {
            localHost = this.isMasterMain() ? host : BootProfileImpl.getDefaultNetworkName();
        }
        profileProp.setProperty("local-host", localHost);
        String localPort = this.argProp.getProperty("local-port");
        if (localPort == null) {
            localPort = this.isMasterMain() ? port : Integer.toString(1099);
        }
        profileProp.setProperty("local-port", localPort);
        value = this.argProp.getProperty("smaddrs");
        if (value != null) {
            try {
                Vector v = Specifier.parseSpecifierList(value);
                ArrayList l = new ArrayList(v.size());
                e = v.elements();
                while (e.hasMoreElements()) {
                    l.add(e.nextElement());
                }
                this.setSpecifiers("smaddrs", l);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        if ((value = this.argProp.getProperty(NAME_KEY)) != null) {
            profileProp.setProperty("platform-id", value);
        }
        if ((value = this.argProp.getProperty(LOGIN_KEY)) != null) {
            profileProp.setProperty("userauth-key", value);
        }
        if ((value = this.argProp.getProperty(MTP_KEY)) != null) {
            this.setSpecifiers("mtps", this.parseSpecifiers(value));
        }
        if (flag = this.fetchAndVerifyBoolean(NOMTP_KEY)) {
            this.setSpecifiers("mtps", new ArrayList(0));
        }
        if ((value = this.argProp.getProperty(ACLCODEC_KEY)) != null) {
            this.setSpecifiers("aclcodecs", this.parseSpecifiers(value));
        }
        value = this.argProp.getProperty("agents");
        flag = this.fetchAndVerifyBoolean(GUI_KEY);
        if (flag) {
            value = value != null ? "RMA:jade.tools.rma.rma " + value : "RMA:jade.tools.rma.rma";
        }
        if (value != null) {
            Vector agentVector = this.helper.T2(value, false);
            ArrayList agents = new ArrayList();
            e = this.helper.getCommandLineAgentSpecifiers(agentVector);
            while (e.hasMoreElements()) {
                agents.add((Specifier)e.nextElement());
            }
            this.setSpecifiers("agents", agents);
        }
        if ((value = this.argProp.getProperty("services")) == null) {
            flag = this.fetchAndVerifyBoolean(NOMOBILITY_KEY);
            value = flag ? "jade.core.event.NotificationService" : "jade.core.mobility.AgentMobilityService;jade.core.event.NotificationService";
        }
        this.setSpecifiers("services", this.parseSpecifiers(value));
        Enumeration<Object> e3 = this.argProp.keys();
        while (e3.hasMoreElements()) {
            String key = (String)e3.nextElement();
            if (this.getParameter(key, null) != null) continue;
            this.setParameter(key, this.argProp.get(key).toString());
        }
        if (this.argProp.getBooleanProperty("dumpProfile", false)) {
            ArrayList aList = new ArrayList();
            System.out.println("---------- Jade Boot profile property values ----------");
            Enumeration e4 = profileProp.sortedKeys();
            while (e4.hasMoreElements()) {
                String key = (String)e4.nextElement();
                Object o = profileProp.get(key);
                if (o.getClass().isAssignableFrom(aList.getClass())) {
                    System.out.print(key + "=");
                    ArrayList al = (ArrayList)o;
                    Iterator itor = al.iterator();
                    if (!itor.hasNext()) {
                        System.out.println("<empty>");
                        continue;
                    }
                    StringBuffer sb = new StringBuffer();
                    while (itor.hasNext()) {
                        sb.append(itor.next());
                        if (!itor.hasNext()) continue;
                        sb.append(" ");
                    }
                    System.out.println(sb.toString());
                    continue;
                }
                System.out.println(key + "=" + profileProp.getProperty(key));
            }
            System.out.println("-------------------------------------------------------");
        }
    }

    protected boolean fetchAndVerifyBoolean(String aKey) throws PropertiesException {
        String value = this.argProp.getProperty(aKey);
        if (value != null) {
            if (value.equalsIgnoreCase("true")) {
                return true;
            }
            if (value.equalsIgnoreCase("false")) {
                return false;
            }
            throw new PropertiesException("The value of the attribute " + aKey + " must be either true or false.");
        }
        return false;
    }

    public List parseSpecifiers(String str) throws PropertiesException {
        ArrayList result = new ArrayList();
        int cursor = 0;
        while (cursor < str.length()) {
            int commaPos = str.indexOf(ARGUMENT_SEPARATOR, cursor);
            if (commaPos == -1) {
                commaPos = str.length();
            }
            String arg = str.substring(cursor, commaPos);
            int openBracketPos = arg.indexOf(40);
            int closedBracketPos = arg.indexOf(41);
            Specifier s = new Specifier();
            if (openBracketPos == -1 && closedBracketPos == -1) {
                s.setClassName(arg);
            } else if (openBracketPos != -1 && closedBracketPos != -1 && openBracketPos < closedBracketPos) {
                s.setClassName(arg.substring(0, openBracketPos));
                Object[] a = new Object[]{arg.substring(openBracketPos + 1, closedBracketPos)};
                s.setArgs(a);
            } else {
                throw new PropertiesException("Ill-formed specifier: mismatched parentheses.");
            }
            cursor = commaPos + 1;
            result.add(s);
        }
        return result;
    }
}

