/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import java.util.Enumeration;
import java.util.Vector;

public class Specifier {
    public static final char SPECIFIER_SEPARATOR = ';';
    public static final String NULL_SPECIFIER_LIST = "null";
    private String name = null;
    private String className = null;
    private Object[] args = null;

    public void setName(String n) {
        this.name = n;
    }

    public String getName() {
        return this.name;
    }

    public void setClassName(String cn) {
        this.className = cn;
    }

    public String getClassName() {
        return this.className;
    }

    public void setArgs(Object[] a) {
        this.args = a;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer();
        if (this.name != null) {
            tmp.append(this.name);
            tmp.append(":");
        }
        if (this.className != null) {
            tmp.append(this.className);
        }
        if (this.args != null) {
            tmp.append("(");
            for (int i = 0; i < this.args.length; ++i) {
                tmp.append(this.args[i]);
                if (i >= this.args.length - 1) continue;
                tmp.append(" ");
            }
            tmp.append(")");
        }
        return tmp.toString();
    }

    public static Vector parseSpecifierList(String specsLine) throws Exception {
        Vector specs = Specifier.parseList(specsLine, ';');
        for (int i = 0; i < specs.size(); ++i) {
            String s = (String)specs.elementAt(i);
            if (s.length() > 0) {
                specs.setElementAt(Specifier.parseSpecifier(s, ','), i);
                continue;
            }
            specs.removeElementAt(i--);
        }
        return specs;
    }

    public static String encodeSpecifierList(Vector v) {
        return Specifier.encodeList(v, ';');
    }

    public static final Vector parseList(String list, char delimiter) {
        Vector<String> v = new Vector<String>();
        if (list != null && !list.equals("") && !list.equals(NULL_SPECIFIER_LIST)) {
            char[] specsChars = new char[list.length()];
            list.getChars(0, list.length(), specsChars, 0);
            StringBuffer sbElement = new StringBuffer();
            for (int i = 0; i < specsChars.length; ++i) {
                char c = specsChars[i];
                if (c != delimiter) {
                    sbElement.append(c);
                    continue;
                }
                v.addElement(sbElement.toString().trim());
                sbElement = new StringBuffer();
            }
            v.addElement(sbElement.toString().trim());
        }
        return v;
    }

    public static String encodeList(Vector v, char delimiter) {
        StringBuffer sb = new StringBuffer();
        Enumeration elements = v.elements();
        while (elements.hasMoreElements()) {
            sb.append(elements.nextElement());
            if (!elements.hasMoreElements()) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static Specifier parseSpecifier(String specString, char argsDelimiter) throws Exception {
        Specifier s = new Specifier();
        int index1 = specString.indexOf(58);
        int index2 = specString.indexOf(40);
        if (index2 < 0) {
            index2 = 99999;
        }
        if (index1 > 0 && index1 < index2) {
            s.setName(specString.substring(0, index1));
            ++index1;
        } else {
            index1 = 0;
        }
        index2 = specString.indexOf(40, index1);
        if (index2 < 0) {
            s.setClassName(specString.substring(index1));
        } else {
            s.setClassName(specString.substring(index1, index2));
            if (!specString.endsWith(")")) {
                throw new Exception("Incorrect specifier \"" + specString + "\". Missing final parenthesis");
            }
            String args = specString.substring(index2 + 1, specString.length() - 1);
            s.setArgs(Specifier.parseArguments(args, argsDelimiter));
        }
        return s;
    }

    private static String[] parseArguments(String args, char argsDelimiter) {
        String arg;
        Vector<String> argList = new Vector<String>();
        int argStart = 0;
        int argEnd = args.indexOf(argsDelimiter);
        while (argEnd >= 0) {
            arg = args.substring(argStart, argEnd);
            argList.addElement(arg.trim());
            argStart = argEnd + 1;
            argEnd = args.indexOf(argsDelimiter, argStart);
        }
        arg = args.substring(argStart, args.length());
        argList.addElement(arg.trim());
        String[] arguments = new String[argList.size()];
        int i = 0;
        Enumeration e = argList.elements();
        while (e.hasMoreElements()) {
            arguments[i++] = (String)e.nextElement();
        }
        return arguments;
    }
}

