/*
 * Decompiled with CFR 0.152.
 */
package jade.core.behaviours;

import jade.core.Agent;
import jade.core.behaviours.CompositeBehaviour;
import jade.core.behaviours.DataStore;
import jade.util.leap.Serializable;

public abstract class Behaviour
implements Serializable {
    private static final long serialVersionUID = 3487495895819001L;
    protected static final int NOTIFY_UP = -1;
    protected static final int NOTIFY_DOWN = 1;
    public static final String STATE_READY = "READY";
    public static final String STATE_BLOCKED = "BLOCKED";
    public static final String STATE_RUNNING = "RUNNING";
    private String myName;
    private boolean startFlag = true;
    protected Agent myAgent;
    private volatile boolean runnableState = true;
    private volatile long restartCounter = 0L;
    private volatile String executionState = "READY";
    protected RunnableChangedEvent myEvent = new RunnableChangedEvent();
    private DataStore myStore;
    private CompositeBehaviour wrappedParent;
    protected CompositeBehaviour parent;

    void setParent(CompositeBehaviour cb) {
        this.parent = cb;
        if (this.parent != null) {
            this.myAgent = this.parent.myAgent;
        }
        this.wrappedParent = null;
    }

    void setWrappedParent(CompositeBehaviour cb) {
        this.wrappedParent = cb;
    }

    protected CompositeBehaviour getParent() {
        if (this.wrappedParent != null) {
            return this.wrappedParent;
        }
        return this.parent;
    }

    public Behaviour() {
        int lastIndex;
        this.myName = this.getClass().getName();
        int dotIndex = this.myName.lastIndexOf(46);
        int dollarIndex = this.myName.lastIndexOf(36);
        int n = lastIndex = dotIndex > dollarIndex ? dotIndex : dollarIndex;
        if (lastIndex != -1) {
            this.myName = this.myName.substring(lastIndex + 1);
        }
    }

    public Behaviour(Agent a) {
        this();
        this.myAgent = a;
    }

    public final void setBehaviourName(String name) {
        this.myName = name;
    }

    public final String getBehaviourName() {
        return this.myName;
    }

    public abstract void action();

    public abstract boolean done();

    public int onEnd() {
        return 0;
    }

    public void onStart() {
    }

    public final void actionWrapper() {
        if (this.startFlag) {
            this.onStart();
            this.startFlag = false;
        }
        if (this.myAgent != null) {
            this.myAgent.notifyChangeBehaviourState(this, STATE_READY, STATE_RUNNING);
        }
        this.action();
        if (this.myAgent != null) {
            this.myAgent.notifyChangeBehaviourState(this, STATE_RUNNING, STATE_READY);
        }
    }

    public final void setExecutionState(String s) {
        this.executionState = s;
    }

    public final String getExecutionState() {
        return this.executionState;
    }

    public void reset() {
        this.startFlag = true;
        this.restart();
    }

    protected void handle(RunnableChangedEvent rce) {
        this.setRunnable(rce.isRunnable());
        if (this.parent != null && rce.isUpwards()) {
            this.parent.handle(rce);
        }
    }

    public Behaviour root() {
        CompositeBehaviour p = this.getParent();
        if (p != null) {
            return p.root();
        }
        return this;
    }

    void setRunnable(boolean runnable) {
        this.runnableState = runnable;
        if (this.runnableState) {
            ++this.restartCounter;
        }
    }

    public boolean isRunnable() {
        return this.runnableState;
    }

    public final long getRestartCounter() {
        return this.restartCounter;
    }

    public void block() {
        this.handleBlockEvent();
    }

    protected void handleBlockEvent() {
        this.myEvent.init(false, -1);
        this.handle(this.myEvent);
    }

    public void block(long millis) {
        this.block();
        if (this.myAgent != null) {
            this.myAgent.restartLater(this, millis);
        }
    }

    public void restart() {
        if (this.myAgent != null) {
            this.myAgent.removeTimer(this);
        }
        this.handleRestartEvent();
        if (this.myAgent != null) {
            this.myAgent.notifyRestarted(this);
        }
    }

    public void handleRestartEvent() {
        this.myEvent.init(true, -1);
        this.handle(this.myEvent);
    }

    public void setAgent(Agent a) {
        this.myAgent = a;
    }

    public Agent getAgent() {
        return this.myAgent;
    }

    public DataStore getDataStore() {
        if (this.myStore == null) {
            this.myStore = new DataStore();
        }
        return this.myStore;
    }

    public void setDataStore(DataStore ds) {
        this.myStore = ds;
    }

    protected class RunnableChangedEvent
    implements Serializable {
        private static final long serialVersionUID = 3487495895819002L;
        private boolean runnable;
        private int direction;

        protected RunnableChangedEvent() {
        }

        public void init(boolean b, int d) {
            this.runnable = b;
            this.direction = d;
        }

        public Behaviour getSource() {
            return Behaviour.this;
        }

        public boolean isRunnable() {
            return this.runnable;
        }

        public boolean isUpwards() {
            return this.direction == -1;
        }
    }
}

