/*
 * Decompiled with CFR 0.152.
 */
package jade.domain;

import jade.core.AID;
import jade.core.AgentManager;
import jade.core.Channel;
import jade.core.ContainerID;
import jade.core.Location;
import jade.core.event.MTPEvent;
import jade.core.event.PlatformEvent;
import jade.domain.ams;
import jade.domain.introspection.AddedContainer;
import jade.domain.introspection.AddedMTP;
import jade.domain.introspection.BornAgent;
import jade.domain.introspection.ChangedAgentOwnership;
import jade.domain.introspection.DeadAgent;
import jade.domain.introspection.EventRecord;
import jade.domain.introspection.FrozenAgent;
import jade.domain.introspection.MovedAgent;
import jade.domain.introspection.PlatformDescription;
import jade.domain.introspection.RemovedContainer;
import jade.domain.introspection.RemovedMTP;
import jade.domain.introspection.ResumedAgent;
import jade.domain.introspection.SuspendedAgent;
import jade.domain.introspection.ThawedAgent;
import jade.util.InputQueue;
import java.util.Date;

public class AMSEventQueueFeeder
implements AgentManager.Listener {
    private InputQueue eventQueue;
    private Location localContainer;
    private ams theAms;

    public AMSEventQueueFeeder(InputQueue eventQueue, Location localContainer) {
        this.eventQueue = eventQueue;
        this.localContainer = localContainer;
    }

    public InputQueue getQueue() {
        return this.eventQueue;
    }

    void setAms(ams ams2) {
        this.theAms = ams2;
        PlatformDescription ap = new PlatformDescription();
        ap.setPlatform(this.theAms.getDescriptionAction(null));
        EventRecord er = new EventRecord(ap, this.localContainer);
        er.setWhen(new Date());
        this.eventQueue.put(er);
    }

    public void bornAgent(PlatformEvent ev) {
        ContainerID cid = ev.getContainer();
        AID agentID = ev.getAgent();
        String ownership = ev.getNewOwnership();
        BornAgent ba = new BornAgent();
        ba.setAgent(agentID);
        ba.setWhere(cid);
        ba.setState("active");
        ba.setOwnership(ownership);
        ba.setClassName((String)agentID.getAllUserDefinedSlot().get("JADE-agent-classname"));
        EventRecord er = new EventRecord(ba, this.localContainer);
        er.setWhen(ev.getTime());
        this.eventQueue.put(er);
    }

    public void deadAgent(PlatformEvent ev) {
        ContainerID cid = ev.getContainer();
        AID agentID = ev.getAgent();
        DeadAgent da = new DeadAgent();
        da.setAgent(agentID);
        da.setWhere(cid);
        if (ev.getContainerRemoved()) {
            da.setContainerRemoved(new Boolean(true));
        }
        EventRecord er = new EventRecord(da, this.localContainer);
        er.setWhen(ev.getTime());
        this.eventQueue.put(er);
    }

    public void suspendedAgent(PlatformEvent ev) {
        ContainerID cid = ev.getContainer();
        AID name = ev.getAgent();
        SuspendedAgent sa = new SuspendedAgent();
        sa.setAgent(name);
        sa.setWhere(cid);
        EventRecord er = new EventRecord(sa, this.localContainer);
        er.setWhen(ev.getTime());
        this.eventQueue.put(er);
    }

    public void resumedAgent(PlatformEvent ev) {
        ContainerID cid = ev.getContainer();
        AID name = ev.getAgent();
        ResumedAgent ra = new ResumedAgent();
        ra.setAgent(name);
        ra.setWhere(cid);
        EventRecord er = new EventRecord(ra, this.localContainer);
        er.setWhen(ev.getTime());
        this.eventQueue.put(er);
    }

    public void frozenAgent(PlatformEvent ev) {
        ContainerID cid = ev.getContainer();
        AID name = ev.getAgent();
        ContainerID bufferContainer = ev.getNewContainer();
        FrozenAgent fa = new FrozenAgent();
        fa.setAgent(name);
        fa.setWhere(cid);
        fa.setBufferContainer(bufferContainer);
        EventRecord er = new EventRecord(fa, this.localContainer);
        er.setWhen(ev.getTime());
        this.eventQueue.put(er);
    }

    public void thawedAgent(PlatformEvent ev) {
        ContainerID cid = ev.getContainer();
        AID name = ev.getAgent();
        ContainerID bufferContainer = ev.getNewContainer();
        ThawedAgent ta = new ThawedAgent();
        ta.setAgent(name);
        ta.setWhere(cid);
        ta.setBufferContainer(bufferContainer);
        EventRecord er = new EventRecord(ta, this.localContainer);
        er.setWhen(ev.getTime());
        this.eventQueue.put(er);
    }

    public void movedAgent(PlatformEvent ev) {
        ContainerID from = ev.getContainer();
        ContainerID to = ev.getNewContainer();
        AID agentID = ev.getAgent();
        MovedAgent ma = new MovedAgent();
        ma.setAgent(agentID);
        ma.setFrom(from);
        ma.setTo(to);
        EventRecord er = new EventRecord(ma, this.localContainer);
        er.setWhen(ev.getTime());
        this.eventQueue.put(er);
    }

    public void changedAgentPrincipal(PlatformEvent ev) {
        ContainerID cid = ev.getContainer();
        AID name = ev.getAgent();
        ChangedAgentOwnership cao = new ChangedAgentOwnership();
        cao.setAgent(name);
        cao.setWhere(cid);
        cao.setFrom(ev.getOldOwnership());
        cao.setTo(ev.getNewOwnership());
        EventRecord er = new EventRecord(cao, this.localContainer);
        er.setWhen(ev.getTime());
        this.eventQueue.put(er);
    }

    public void addedContainer(PlatformEvent ev) {
        ContainerID cid = ev.getContainer();
        String name = cid.getName();
        AddedContainer ac = new AddedContainer();
        ac.setContainer(cid);
        EventRecord er = new EventRecord(ac, this.localContainer);
        er.setWhen(ev.getTime());
        this.eventQueue.put(er);
    }

    public void removedContainer(PlatformEvent ev) {
        ContainerID cid = ev.getContainer();
        String name = cid.getName();
        RemovedContainer rc = new RemovedContainer();
        rc.setContainer(cid);
        EventRecord er = new EventRecord(rc, this.localContainer);
        er.setWhen(ev.getTime());
        this.eventQueue.put(er);
    }

    public synchronized void changedContainerPrincipal(PlatformEvent ev) {
    }

    public synchronized void addedMTP(MTPEvent ev) {
        Channel ch = ev.getChannel();
        ContainerID cid = ev.getPlace();
        String proto = ch.getProtocol();
        String address = ch.getAddress();
        AddedMTP amtp = new AddedMTP();
        amtp.setAddress(address);
        amtp.setProto(proto);
        amtp.setWhere(cid);
        EventRecord er = new EventRecord(amtp, this.localContainer);
        er.setWhen(ev.getTime());
        this.eventQueue.put(er);
        if (this.theAms != null) {
            PlatformDescription ap = new PlatformDescription();
            ap.setPlatform(this.theAms.getDescriptionAction(null));
            er = new EventRecord(ap, this.localContainer);
            er.setWhen(ev.getTime());
            this.eventQueue.put(er);
        }
    }

    public synchronized void removedMTP(MTPEvent ev) {
        Channel ch = ev.getChannel();
        ContainerID cid = ev.getPlace();
        String proto = ch.getProtocol();
        String address = ch.getAddress();
        RemovedMTP rmtp = new RemovedMTP();
        rmtp.setAddress(address);
        rmtp.setProto(proto);
        rmtp.setWhere(cid);
        EventRecord er = new EventRecord(rmtp, this.localContainer);
        er.setWhen(ev.getTime());
        this.eventQueue.put(er);
        if (this.theAms != null) {
            PlatformDescription ap = new PlatformDescription();
            ap.setPlatform(this.theAms.getDescriptionAction(null));
            er = new EventRecord(ap, this.localContainer);
            er.setWhen(ev.getTime());
            this.eventQueue.put(er);
        }
    }

    public void messageIn(MTPEvent ev) {
    }

    public void messageOut(MTPEvent ev) {
    }
}

