/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap;

import jade.imtp.leap.Command;
import jade.imtp.leap.LEAPSerializationException;
import jade.imtp.leap.SerializationEngine;

public abstract class MicroSkeleton {
    public byte[] handleCommand(byte[] cmd) {
        byte[] rsp = null;
        try {
            Command c = SerializationEngine.deserialize(cmd);
            Command r = this.executeCommand(c);
            rsp = SerializationEngine.serialize(r);
        }
        catch (Throwable tr) {
            tr.printStackTrace();
            Command r = this.createErrorRsp(tr, false);
            try {
                rsp = SerializationEngine.serialize(r);
            }
            catch (LEAPSerializationException lse) {
                lse.printStackTrace();
            }
        }
        return rsp;
    }

    abstract Command executeCommand(Command var1) throws Throwable;

    protected Command createErrorRsp(Throwable tr, boolean expected) {
        Command rsp = new Command(2);
        rsp.addParam(new Boolean(expected));
        rsp.addParam(tr.getClass().getName());
        rsp.addParam(tr.getMessage());
        return rsp;
    }
}

