/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.rmi;

import jade.core.BaseNode;
import jade.core.HorizontalCommand;
import jade.core.IMTPException;
import jade.imtp.rmi.NodeRMI;
import jade.imtp.rmi.NodeRMIImpl;
import jade.imtp.rmi.RMIIMTPManager;
import java.rmi.RemoteException;

class NodeAdapter
extends BaseNode {
    private NodeRMI adaptee;

    public NodeAdapter(String name, boolean hasSM, int port, RMIIMTPManager mgr) throws RemoteException {
        super(name, hasSM);
        try {
            this.adaptee = new NodeRMIImpl(this, port, mgr);
        }
        catch (Exception e) {
            this.adaptee = new NodeRMIImpl(this, 0, mgr);
        }
    }

    public Object accept(HorizontalCommand cmd) throws IMTPException {
        try {
            return this.adaptee.accept(cmd);
        }
        catch (RemoteException re) {
            throw new IMTPException("An RMI error occurred", re);
        }
    }

    public NodeRMI getRMIStub() {
        return this.adaptee;
    }

    public boolean ping(boolean hang) throws IMTPException {
        try {
            return this.adaptee.ping(hang);
        }
        catch (RemoteException re) {
            throw new IMTPException("RMI exception", re);
        }
    }

    public void exit() throws IMTPException {
        try {
            this.adaptee.exit();
        }
        catch (RemoteException re) {
            throw new IMTPException("RMI exception", re);
        }
    }

    public void interrupt() throws IMTPException {
        try {
            this.adaptee.interrupt();
        }
        catch (RemoteException re) {
            throw new IMTPException("RMI exception", re);
        }
    }

    public void platformManagerDead(String deadPmAddress, String notifyingPmAddr) throws IMTPException {
        if (this.myServiceManager != null) {
            super.platformManagerDead(deadPmAddress, notifyingPmAddr);
        } else {
            try {
                this.adaptee.platformManagerDead(deadPmAddress, notifyingPmAddr);
            }
            catch (RemoteException re) {
                throw new IMTPException("RMI exception", re);
            }
        }
    }
}

