/*
 * Decompiled with CFR 0.152.
 */
package jade.util;

import jade.util.Logger;
import jade.util.PropertiesException;
import jade.util.leap.Properties;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ExtendedProperties
extends Properties {
    public static final String IMPORT_KEY = "import";
    boolean CRState = false;
    Hashtable keyNames = new Hashtable();
    Vector sortVector = null;
    private Logger logger = Logger.getMyLogger(this.getClass().getName());

    public static void main(String[] args) {
        ExtendedProperties prop = new ExtendedProperties(args);
        prop.list(System.out);
    }

    public ExtendedProperties() {
    }

    public ExtendedProperties(String[] propesStr) {
        this();
        this.addProperties(propesStr);
    }

    public synchronized void load(InputStream inStream) throws IOException {
        this.addFromReader(new InputStreamReader(inStream, "8859_1"));
    }

    public synchronized void store(OutputStream out, String header) throws IOException {
        String lineSeparator = System.getProperty("line.separator");
        OutputStreamWriter writer = new OutputStreamWriter(out, "8859_1");
        if (header != null) {
            writer.write("#" + header);
            writer.write(lineSeparator);
        }
        writer.write("#" + new Date().toString());
        writer.write(lineSeparator);
        Enumeration e = this.sortedKeys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Object data = super.get(key);
            if (data == null) continue;
            writer.write(key + "=" + data.toString());
            writer.write(lineSeparator);
        }
        ((Writer)writer).flush();
    }

    public synchronized Enumeration sortedKeys() {
        if (this.sortVector == null) {
            this.sortVector = new Vector();
        } else {
            this.sortVector.removeAllElements();
        }
        Enumeration<Object> e = super.keys();
        while (e.hasMoreElements()) {
            int i;
            String key = (String)e.nextElement();
            for (i = 0; i < this.sortVector.size() && key.compareTo((String)this.sortVector.elementAt(i)) >= 0; ++i) {
            }
            this.sortVector.insertElementAt(key, i);
        }
        return new Enumeration(){
            Enumeration en;
            {
                this.en = ExtendedProperties.this.sortVector.elements();
            }

            public boolean hasMoreElements() {
                return this.en.hasMoreElements();
            }

            public Object nextElement() {
                return this.en.nextElement();
            }
        };
    }

    public synchronized void addProperties(String[] propsStr) {
        if (propsStr != null) {
            for (int i = 0; i < propsStr.length; ++i) {
                this.addProperty(propsStr[i]);
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addProperty(String propStr) {
        void var3_7;
        if (propStr == null) throw new PropertiesException("Null property format");
        propStr.trim();
        String key = null;
        Object var3_3 = null;
        int separatorIndex = this.getSeparatorIndex(propStr);
        if (separatorIndex > 0) {
            key = propStr.substring(0, separatorIndex).trim();
            if (key.length() == 0) {
                throw new PropertiesException("Unable to identify key part in property: " + propStr);
            }
            if (separatorIndex == propStr.length() - 1) {
                Object var3_4 = null;
            } else {
                String string = propStr.substring(separatorIndex + 1).trim();
            }
        } else {
            if (propStr.length() <= 1 || !propStr.startsWith("-")) throw new PropertiesException("Wrong property format: " + propStr);
            key = propStr.substring(1);
            String string = "true";
        }
        this.setProperty(key, (String)var3_7);
    }

    protected int getSeparatorIndex(String propStr) {
        int idxA = propStr.indexOf(61);
        int idxB = propStr.indexOf(58);
        if (idxA == -1) {
            return idxB;
        }
        if (idxB == -1) {
            return idxA;
        }
        if (idxA < idxB) {
            return idxA;
        }
        return idxB;
    }

    public synchronized void copyProperties(ExtendedProperties source) {
        Enumeration<Object> e = source.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            super.put(key, source.getRawProperty(key));
        }
    }

    public synchronized ExtendedProperties extractSubset(String prefix) {
        ExtendedProperties result = new ExtendedProperties();
        Enumeration<Object> e = super.keys();
        while (e.hasMoreElements()) {
            String originalKey = (String)e.nextElement();
            String newKey = null;
            if (!originalKey.startsWith(prefix)) continue;
            newKey = originalKey.substring(prefix.length());
            result.setProperty(newKey, this.getRawProperty(originalKey));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object aKey) {
        Object value = null;
        if (aKey instanceof String) {
            String strKey = (String)aKey;
            String testKey = strKey.endsWith("!") ? strKey.substring(0, strKey.length()) : strKey;
            value = super.get(testKey);
            if (value == null) {
                value = super.get(testKey + "!");
            }
            if (value != null && value instanceof String) {
                String strValue = (String)value;
                Hashtable hashtable = this.keyNames;
                synchronized (hashtable) {
                    if (this.keyNames.put(testKey, "x") != null) {
                        throw new PropertiesException("Circular argument substitution with key: " + aKey);
                    }
                    if (strValue.length() >= 4) {
                        strValue = this.doSubstitutions(strValue);
                    }
                    this.keyNames.remove(testKey);
                }
                strValue = this.valueFilter(strKey, strValue);
                value = strValue;
            }
        } else {
            value = super.get(aKey);
        }
        return value;
    }

    public Object put(Object aKey, Object aValue) {
        if (aKey instanceof String) {
            String testKey;
            String actualKey = this.doSubstitutions((String)aKey);
            String string = testKey = actualKey.endsWith("!") ? actualKey.substring(0, actualKey.length()) : actualKey;
            if (super.containsKey(testKey + "!")) {
                throw new PropertiesException("Attempt to alter read only property:" + testKey);
            }
            if (actualKey.equals(IMPORT_KEY) && aValue != null) {
                String importFile = this.doSubstitutions(aValue.toString());
                try {
                    InputStream stream = this.getClass().getClassLoader().getResourceAsStream(importFile);
                    if (stream == null) {
                        stream = new FileInputStream(importFile);
                    }
                    this.load(stream);
                }
                catch (IOException ioe) {
                    this.logger.log(Logger.WARNING, "Cannot import properties from import-file " + importFile);
                }
                return null;
            }
            return super.put(actualKey, aValue);
        }
        return super.put(aKey, aValue);
    }

    public String getProperty(String aKey) {
        return this.getProperty(aKey, null);
    }

    public String getProperty(String aKey, String defaultValue) {
        Object value = this.get(aKey);
        if (value != null) {
            return value.toString();
        }
        return defaultValue;
    }

    public Object setPropertyIfNot(String aKey, String value) {
        String current = this.getProperty(aKey);
        if (current == null) {
            return this.setProperty(aKey, value);
        }
        return current;
    }

    public String getRawProperty(String aKey) {
        Object data = super.get(aKey);
        return data != null ? data.toString() : null;
    }

    public String getPropertyIgnoreCase(String aKey) {
        Enumeration<Object> e = super.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!aKey.equalsIgnoreCase(key)) continue;
            return this.getProperty(key);
        }
        return null;
    }

    protected String valueFilter(String key, String value) {
        if (key.toLowerCase().indexOf("path") >= 0) {
            String correctSeparator = System.getProperty("path.separator");
            value = correctSeparator.equals(";") ? value.replace('|', ';') : value.replace('|', ':');
        }
        return value;
    }

    public int getIntProperty(String aKey, int aDefaultValue) {
        int result = aDefaultValue;
        try {
            result = Integer.parseInt(this.getProperty(aKey));
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    public int setIntProperty(String aKey, int aValue) {
        this.setProperty(aKey, Integer.toString(aValue));
        return aValue;
    }

    public boolean getBooleanProperty(String aKey, boolean aDefaultValue) {
        boolean result = aDefaultValue;
        try {
            String value = this.getProperty(aKey);
            result = value.equalsIgnoreCase("true");
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    public void setBooleanProperty(String aKey, boolean aValue) {
        this.setProperty(aKey, aValue ? "true" : "false");
    }

    public Object renameKey(String existingKey, String newKey) {
        Object value = this.remove(this.doSubstitutions(existingKey));
        if (value != null) {
            return this.put(newKey, value);
        }
        return null;
    }

    public String doSubstitutions(String anInputString) {
        return this.doSubstitutions(anInputString, false);
    }

    public String doSubstitutions(String anInputString, boolean allowUndefined) {
        if (anInputString == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int si = 0;
        int oi = 0;
        int ci = 0;
        do {
            oi = anInputString.indexOf("${", si);
            ci = anInputString.indexOf(125, si);
            if (oi > si) {
                result.append(anInputString.substring(si, oi));
                si = oi;
            }
            if (oi == si && ci > oi + 2) {
                String key = anInputString.substring(oi + 2, ci);
                String value = this.getProperty(key, null);
                if (value == null && (value = System.getProperty(key)) == null) {
                    value = System.getenv(key);
                }
                if (value == null) {
                    if (allowUndefined) {
                        value = "${" + key + "}";
                    } else {
                        throw new PropertiesException("Unable to get property value for key: " + key);
                    }
                }
                if (oi > si) {
                    result.append(anInputString.substring(si, oi));
                }
                result.append(value);
                si = ci + 1;
                continue;
            }
            if (oi == -1) {
                result.append(anInputString.substring(si, anInputString.length()));
                si = anInputString.length();
                continue;
            }
            result.append(anInputString.substring(si, oi + 2));
            si = oi + 2;
        } while (si < anInputString.length());
        return result.toString();
    }

    protected void addFromReader(Reader reader) throws IOException {
        String line = null;
        do {
            if ((line = this.getOneLine(reader)) == null || (line = line.trim()).length() == 0 || line.startsWith("#") || line.startsWith("!")) continue;
            this.addProperty(line);
        } while (line != null);
    }

    protected String getOneLine(Reader reader) throws IOException {
        boolean continued;
        StringBuffer sb = null;
        String line = null;
        do {
            continued = false;
            try {
                line = this.readLine(reader);
                if (line == null) continue;
                line = line.trim();
                if (sb != null && (line.length() == 0 || line.startsWith("#") || line.startsWith("!"))) {
                    continued = true;
                    continue;
                }
                continued = line.endsWith("\\");
                if (continued) {
                    line = line.substring(0, line.length() - 1);
                }
                if (sb == null) {
                    sb = new StringBuffer();
                }
                sb.append(line);
            }
            catch (EOFException eof) {
                continued = false;
            }
        } while (continued);
        return sb == null ? null : sb.toString();
    }

    protected String readLine(Reader aReader) throws IOException {
        StringBuffer sb = new StringBuffer();
        boolean done = false;
        while (!done) {
            int result = aReader.read();
            if (result == -1) {
                if (sb.length() > 0) break;
                throw new EOFException();
            }
            char ch = (char)result;
            if (ch == '\n') {
                if (!this.CRState) break;
                this.CRState = false;
                continue;
            }
            if (ch == '\r') {
                this.CRState = true;
                break;
            }
            sb.append(ch);
            this.CRState = false;
        }
        return sb.toString();
    }

    public void list(PrintStream out) {
        Enumeration e = this.sortedKeys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = this.getProperty(key);
            if (value != null) {
                out.println(key + "=" + value);
                continue;
            }
            out.println(key + "=");
        }
    }

    public String[] toStringArray() {
        String[] result = new String[super.size()];
        int i = 0;
        Enumeration e = this.sortedKeys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = this.getProperty(key);
            if (value != null) {
                result[i++] = key + "=" + value;
                continue;
            }
            result[i++] = key + "=";
        }
        return result;
    }
}

