/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.util;

import bdi4jade.annotation.Belief;
import bdi4jade.annotation.Parameter;
import bdi4jade.core.Capability;
import bdi4jade.exception.ParameterException;
import bdi4jade.goal.Goal;
import bdi4jade.plan.planbody.PlanBody;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ReflectionUtils {
    private static final String GETTER_PREFIX = "get";
    private static final Log log = LogFactory.getLog(ReflectionUtils.class);
    private static final String SETTER_PREFIX = "set";

    public static void addGoalOwner(Map<Class<? extends Capability>, Set<Capability>> goalOwnersMap, Capability capability) {
        if (!Capability.class.equals(capability.getClass())) {
            ReflectionUtils.addGoalOwner(goalOwnersMap, capability.getClass(), capability);
            for (Class<? extends Capability> parentCapability : capability.getParentCapabilities()) {
                ReflectionUtils.addGoalOwner(goalOwnersMap, parentCapability, capability);
            }
        } else assert (capability.getParentCapabilities().isEmpty());
    }

    private static void addGoalOwner(Map<Class<? extends Capability>, Set<Capability>> goalOwnersMap, Class<? extends Capability> cababilityClass, Capability capability) {
        Set<Capability> owners = goalOwnersMap.get(cababilityClass);
        if (owners == null) {
            owners = new HashSet<Capability>();
            goalOwnersMap.put(cababilityClass, owners);
        }
        owners.add(capability);
    }

    private static void checkSkipIsOK(Parameter parameter, String msg, Exception cause) throws ParameterException {
        if (parameter.mandatory()) {
            ParameterException exc = new ParameterException(msg, cause);
            log.warn((Object)exc);
            throw exc;
        }
    }

    private static boolean isGetter(Method method) {
        if (!method.getName().startsWith(GETTER_PREFIX)) {
            return false;
        }
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        return !Void.TYPE.equals(method.getReturnType());
    }

    private static boolean isParameterIn(Parameter param, Parameter.Direction[] directions) {
        Parameter.Direction[] directionArray = directions;
        int n = directions.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter.Direction dir = directionArray[n2];
            if (dir.equals((Object)param.direction())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isSetter(Method method) {
        if (!method.getName().startsWith(SETTER_PREFIX)) {
            return false;
        }
        if (method.getParameterTypes().length != 1) {
            return false;
        }
        return Void.TYPE.equals(method.getReturnType());
    }

    private static String methodToPropertyName(String prefix, Method method) {
        String property = method.getName().substring(prefix.length());
        return String.valueOf(property.substring(0, 1).toLowerCase()) + property.substring(1);
    }

    private static String propertyToMethodName(String prefix, String property) {
        return String.valueOf(prefix) + property.substring(0, 1).toUpperCase() + property.substring(1);
    }

    public static void setPlanBodyInput(PlanBody planBody, Goal goal) throws ParameterException {
        ReflectionUtils.setupParameters(planBody, new Parameter.Direction[]{Parameter.Direction.IN, Parameter.Direction.INOUT}, goal, new Parameter.Direction[]{Parameter.Direction.IN, Parameter.Direction.INOUT});
    }

    public static void setPlanBodyOutput(PlanBody planBody, Goal goal) throws ParameterException {
        ReflectionUtils.setupParameters(goal, new Parameter.Direction[]{Parameter.Direction.OUT, Parameter.Direction.INOUT}, planBody, new Parameter.Direction[]{Parameter.Direction.OUT, Parameter.Direction.INOUT});
    }

    public static void setupBeliefs(PlanBody planBody) {
        Capability capability = planBody.getPlan().getPlanLibrary().getCapability();
        Class<?> currentClass = planBody.getClass();
        while (PlanBody.class.isAssignableFrom(currentClass)) {
            Field[] fieldArray = currentClass.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                boolean b;
                Field field;
                block6: {
                    field = fieldArray[n2];
                    b = field.isAccessible();
                    field.setAccessible(true);
                    try {
                        if (!field.isAnnotationPresent(Belief.class)) break block6;
                        if (bdi4jade.belief.Belief.class.isAssignableFrom(field.getType())) {
                            Belief beliefAnnotation = field.getAnnotation(Belief.class);
                            String beliefName = beliefAnnotation.name();
                            if (beliefName == null || "".equals(beliefName)) {
                                beliefName = field.getName();
                            }
                            bdi4jade.belief.Belief<?, ?> belief = capability.getBeliefBase().getBelief(beliefName);
                            field.set(planBody, belief);
                            break block6;
                        }
                        throw new ClassCastException("Field " + field.getName() + " should be a Belief");
                    }
                    catch (Exception exc) {
                        log.warn((Object)exc);
                    }
                }
                field.setAccessible(b);
                ++n2;
            }
            currentClass = currentClass.getSuperclass();
        }
    }

    public static void setupParameters(Goal goalOut, Goal goalIn) throws ParameterException {
        ReflectionUtils.setupParameters(goalIn, new Parameter.Direction[]{Parameter.Direction.IN, Parameter.Direction.INOUT}, goalOut, new Parameter.Direction[]{Parameter.Direction.OUT, Parameter.Direction.INOUT});
    }

    private static void setupParameters(Object obj1, Parameter.Direction[] dir1, Object obj2, Parameter.Direction[] dir2) throws ParameterException {
        Method[] methodArray = obj1.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            block13: {
                Parameter parameter;
                Method method = methodArray[n2];
                if (method.isAnnotationPresent(Parameter.class) && ReflectionUtils.isParameterIn(parameter = method.getAnnotation(Parameter.class), dir1)) {
                    Method getter;
                    Method setter;
                    block14: {
                        if (!ReflectionUtils.isGetter(method) && !ReflectionUtils.isSetter(method)) {
                            ReflectionUtils.checkSkipIsOK(parameter, "Method " + method + " should be a getter or setter.", null);
                        } else {
                            String property;
                            block12: {
                                property = null;
                                setter = null;
                                if (ReflectionUtils.isGetter(method)) {
                                    property = ReflectionUtils.methodToPropertyName(GETTER_PREFIX, method);
                                    try {
                                        setter = obj1.getClass().getMethod(ReflectionUtils.propertyToMethodName(SETTER_PREFIX, property), method.getReturnType());
                                        break block12;
                                    }
                                    catch (NoSuchMethodException nsme) {
                                        ReflectionUtils.checkSkipIsOK(parameter, "There is no setter method associated with property " + property, nsme);
                                        break block13;
                                    }
                                }
                                property = ReflectionUtils.methodToPropertyName(SETTER_PREFIX, method);
                                setter = method;
                            }
                            getter = null;
                            try {
                                getter = obj2.getClass().getMethod(ReflectionUtils.propertyToMethodName(GETTER_PREFIX, property), new Class[0]);
                                if (!getter.isAnnotationPresent(Parameter.class) || !ReflectionUtils.isParameterIn(getter.getAnnotation(Parameter.class), dir2)) {
                                    ReflectionUtils.checkSkipIsOK(parameter, "There is no parameter associated with method " + method + " name " + property, null);
                                }
                                break block14;
                            }
                            catch (NoSuchMethodException nsme) {
                                ReflectionUtils.checkSkipIsOK(parameter, "There is no getter method associated with property " + property, nsme);
                            }
                        }
                        break block13;
                    }
                    try {
                        setter.invoke(obj1, getter.invoke(obj2, new Object[0]));
                    }
                    catch (Exception exc) {
                        ReflectionUtils.checkSkipIsOK(parameter, "An unknown error occurrred.", exc);
                    }
                }
            }
            ++n2;
        }
    }
}

