/*
 * Decompiled with CFR 0.152.
 */
package jade.proto;

import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.DataStore;
import jade.core.behaviours.OneShotBehaviour;
import jade.lang.acl.ACLMessage;
import jade.proto.Initiator;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.Serializable;
import java.util.Vector;

public class SubscriptionInitiator
extends Initiator {
    public final String SUBSCRIPTION_KEY;
    public final String ALL_SUBSCRIPTIONS_KEY;
    public final String REPLY_KEY;
    public final String ALL_RESPONSES_KEY;
    private static final String HANDLE_AGREE = "Handle-agree";
    private static final String HANDLE_REFUSE = "Handle-refuse";
    private static final String HANDLE_INFORM = "Handle-inform";
    private static final String HANDLE_ALL_RESPONSES = "Handle-all-responses";
    private static final String CHECK_AGAIN = "Check-again";
    private static final int ALL_RESPONSES_RECEIVED = 1;
    private static final int TERMINATED = 2;
    private boolean allResponsesReceived;
    private String[] toBeReset;

    public SubscriptionInitiator(Agent a, ACLMessage msg) {
        this(a, msg, new DataStore());
    }

    public SubscriptionInitiator(Agent a, ACLMessage msg, DataStore store) {
        super(a, msg, store);
        this.SUBSCRIPTION_KEY = this.INITIATION_K;
        this.ALL_SUBSCRIPTIONS_KEY = this.ALL_INITIATIONS_K;
        this.REPLY_KEY = this.REPLY_K;
        this.ALL_RESPONSES_KEY = "__all-responses" + this.hashCode();
        this.allResponsesReceived = false;
        this.toBeReset = null;
        this.registerTransition("Check-in-seq", HANDLE_AGREE, 1);
        this.registerTransition("Check-in-seq", HANDLE_INFORM, 7);
        this.registerTransition("Check-in-seq", HANDLE_REFUSE, 14);
        this.registerDefaultTransition(HANDLE_AGREE, "Check-sessions");
        this.registerDefaultTransition(HANDLE_INFORM, "Check-sessions");
        this.registerDefaultTransition(HANDLE_REFUSE, "Check-sessions");
        this.registerTransition("Check-sessions", HANDLE_ALL_RESPONSES, 1);
        this.registerTransition("Check-sessions", "Dummy-final", 2);
        this.registerDefaultTransition(HANDLE_ALL_RESPONSES, CHECK_AGAIN);
        this.registerTransition(CHECK_AGAIN, "Dummy-final", 0);
        this.registerDefaultTransition(CHECK_AGAIN, "Receive-reply", this.getToBeReset());
        OneShotBehaviour b = null;
        b = new OneShotBehaviour(this.myAgent){
            private static final long serialVersionUID = 3487495895820003L;

            public void action() {
                SubscriptionInitiator.this.handleAgree((ACLMessage)this.getDataStore().get(SubscriptionInitiator.this.REPLY_K));
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerState(b, HANDLE_AGREE);
        b = new OneShotBehaviour(this.myAgent){
            private static final long serialVersionUID = 3487495895820004L;

            public void action() {
                SubscriptionInitiator.this.handleRefuse((ACLMessage)this.getDataStore().get(SubscriptionInitiator.this.REPLY_K));
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerState(b, HANDLE_REFUSE);
        b = new OneShotBehaviour(this.myAgent){
            private static final long serialVersionUID = 3487495895820006L;

            public void action() {
                SubscriptionInitiator.this.handleInform((ACLMessage)this.getDataStore().get(SubscriptionInitiator.this.REPLY_K));
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerState(b, HANDLE_INFORM);
        b = new OneShotBehaviour(this.myAgent){

            public void action() {
                SubscriptionInitiator.this.handleAllResponses((Vector)this.getDataStore().get(SubscriptionInitiator.this.ALL_RESPONSES_KEY));
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerState(b, HANDLE_ALL_RESPONSES);
        b = new OneShotBehaviour(this.myAgent){

            public void action() {
            }

            public int onEnd() {
                return SubscriptionInitiator.this.sessions.size();
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerState(b, CHECK_AGAIN);
    }

    protected Vector prepareInitiations(ACLMessage initiation) {
        return this.prepareSubscriptions(initiation);
    }

    protected boolean checkInSequence(ACLMessage reply) {
        int perf;
        String inReplyTo = reply.getInReplyTo();
        Session s = (Session)this.sessions.get(inReplyTo);
        if (s != null && s.update(perf = reply.getPerformative())) {
            switch (s.getState()) {
                case 1: 
                case 2: {
                    Vector allRsp = (Vector)this.getDataStore().get(this.ALL_RESPONSES_KEY);
                    allRsp.addElement(reply);
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    return false;
                }
            }
            if (s.isCompleted()) {
                this.sessions.remove(inReplyTo);
            }
            return true;
        }
        return false;
    }

    protected int checkSessions(ACLMessage reply) {
        int ret = -1;
        if (this.getLastExitValue() == -1001) {
            if (!this.allResponsesReceived) {
                ArrayList sessionsToRemove = new ArrayList(this.sessions.size());
                Iterator i = this.sessions.keySet().iterator();
                while (i.hasNext()) {
                    Object key = i.next();
                    Session s = (Session)this.sessions.get(key);
                    if (s.getState() != 0) continue;
                    sessionsToRemove.add(key);
                }
                i = sessionsToRemove.iterator();
                while (i.hasNext()) {
                    this.sessions.remove(i.next());
                }
                sessionsToRemove = null;
            } else {
                this.sessions.clear();
            }
        }
        if (!this.allResponsesReceived) {
            this.allResponsesReceived = true;
            Iterator it = this.sessions.values().iterator();
            while (it.hasNext()) {
                Session s = (Session)it.next();
                if (s.getState() != 0) continue;
                this.allResponsesReceived = false;
                break;
            }
            if (this.allResponsesReceived) {
                this.replyReceiver.setDeadline(-1L);
                ret = 1;
            }
        } else if (this.sessions.size() == 0) {
            ret = 2;
        }
        return ret;
    }

    protected String[] getToBeReset() {
        if (this.toBeReset == null) {
            this.toBeReset = new String[]{HANDLE_AGREE, HANDLE_REFUSE, "Handle-not-understood", HANDLE_INFORM, "Handle-failure", "Handle-out-of-seq"};
        }
        return this.toBeReset;
    }

    protected Vector prepareSubscriptions(ACLMessage subscription) {
        Vector<ACLMessage> l = new Vector<ACLMessage>(1);
        l.addElement(subscription);
        return l;
    }

    protected void handleAgree(ACLMessage agree) {
    }

    protected void handleRefuse(ACLMessage refuse) {
    }

    protected void handleInform(ACLMessage inform) {
    }

    protected void handleAllResponses(Vector responses) {
    }

    public void registerPrepareSubscriptions(Behaviour b) {
        this.registerPrepareInitiations(b);
    }

    public void registerHandleAgree(Behaviour b) {
        this.registerState(b, HANDLE_AGREE);
        b.setDataStore(this.getDataStore());
    }

    public void registerHandleInform(Behaviour b) {
        this.registerState(b, HANDLE_INFORM);
        b.setDataStore(this.getDataStore());
    }

    public void registerHandleRefuse(Behaviour b) {
        this.registerState(b, HANDLE_REFUSE);
        b.setDataStore(this.getDataStore());
    }

    public void registerHandleAllResponses(Behaviour b) {
        this.registerState(b, HANDLE_ALL_RESPONSES);
        b.setDataStore(this.getDataStore());
    }

    public void cancel(AID receiver, boolean ignoreResponse) {
        ACLMessage subscription = (ACLMessage)this.getDataStore().get(receiver);
        Session s = (Session)this.sessions.get(subscription.getReplyWith());
        if (s != null) {
            if (ignoreResponse) {
                this.sessions.remove(subscription.getReplyWith());
            } else {
                s.cancel();
            }
            ACLMessage cancel = new ACLMessage(2);
            cancel.addReceiver(receiver);
            cancel.setLanguage(subscription.getLanguage());
            cancel.setOntology(subscription.getOntology());
            cancel.setProtocol(subscription.getProtocol());
            cancel.setConversationId(subscription.getConversationId());
            if (!ignoreResponse) {
                cancel.setReplyWith(subscription.getReplyWith());
            }
            this.fillCancelContent(subscription, cancel);
            this.myAgent.send(cancel);
            this.replyReceiver.interrupt();
        }
    }

    protected void fillCancelContent(ACLMessage subscription, ACLMessage cancel) {
        cancel.setContent(null);
    }

    public void cancellationCompleted(AID receiver) {
        ACLMessage subscription = (ACLMessage)this.getDataStore().get(receiver);
        Session s = (Session)this.sessions.get(subscription.getReplyWith());
        if (s != null && s.isCancelled()) {
            this.sessions.remove(subscription.getReplyWith());
            this.replyReceiver.interrupt();
        }
    }

    protected void reinit() {
        this.allResponsesReceived = false;
        super.reinit();
    }

    protected void initializeDataStore(ACLMessage msg) {
        super.initializeDataStore(msg);
        Vector l = new Vector();
        this.getDataStore().put(this.ALL_RESPONSES_KEY, l);
    }

    protected Initiator.ProtocolSession getSession(ACLMessage msg, int sessionIndex) {
        this.getDataStore().put((AID)msg.getAllReceiver().next(), msg);
        return new Session();
    }

    private static class Session
    implements Initiator.ProtocolSession,
    Serializable {
        static final int INIT = 0;
        static final int POSITIVE_RESPONSE_RECEIVED = 1;
        static final int NEGATIVE_RESPONSE_RECEIVED = 2;
        static final int NOTIFICATION_RECEIVED = 3;
        private int state = 0;
        private boolean cancelled = false;

        private Session() {
        }

        public String getId() {
            return null;
        }

        public boolean update(int perf) {
            switch (this.state) {
                case 0: {
                    switch (perf) {
                        case 1: {
                            this.state = 1;
                            return true;
                        }
                        case 10: 
                        case 14: {
                            this.state = 2;
                            return true;
                        }
                        case 6: 
                        case 7: {
                            this.state = 3;
                            return true;
                        }
                    }
                    return false;
                }
                case 1: 
                case 3: {
                    switch (perf) {
                        case 6: 
                        case 7: {
                            this.state = 3;
                            return true;
                        }
                    }
                    return false;
                }
            }
            return false;
        }

        public int getState() {
            return this.state;
        }

        public boolean isCompleted() {
            return this.state == 2;
        }

        void cancel() {
            this.cancelled = true;
        }

        boolean isCancelled() {
            return this.cancelled;
        }
    }
}

