package bdi4jade.extension.remediation;

import bdi4jade.annotation.Belief;
import bdi4jade.core.Capability;
import bdi4jade.extension.remediation.graph.CauseEffectKnowledgeModel;
import bdi4jade.extension.remediation.reasoning.RemediationOptionGenerationFunction;
import bdi4jade.extension.remediation.reasoning.RemediationPlanSelectionStrategy;

public class RemediationCapability extends Capability {

	private static final long serialVersionUID = -1818834346847016992L;

	@Belief(name = CauseEffectKnowledgeModel.NAME)
	protected CauseEffectKnowledgeModel causeEffectKnowledgeModel = new CauseEffectKnowledgeModel();

	@Belief(name = ResourcePreferences.NAME)
	protected ResourcePreferences preferences = new ResourcePreferences();

	public RemediationCapability() {
		setOptionGenerationFunction(new RemediationOptionGenerationFunction(this));
		setPlanSelectionStrategy(new RemediationPlanSelectionStrategy(this));
	}

}
