package bdi4jade.examples.undo.domain;

import java.io.Serializable;

import jade.content.Concept;
import jade.content.ContentElement;

/**
 * @author jgfaccin
 *
 */
public abstract class Device implements Serializable, Concept, ContentElement {

	private static final long serialVersionUID = 3230147050332280745L;

	private String id;

	public Device(String id) {
		this.id = id;
	}

	@Override
	public boolean equals(Object obj) {
		if (obj instanceof Device) {
			Device device = (Device) obj;
			return this.id.equals(device.id);
		}
		return false;
	}

	public String getId() {
		return id;
	}

	@Override
	public int hashCode() {
		return id == null ? 0 : id.hashCode();
	}

	public void setId(String id) {
		this.id = id;
	}

	@Override
	public String toString() {
		return id;
	}

}
