/*
 * Decompiled with CFR 0.152.
 */
package jade.core.faultRecovery;

import jade.core.Profile;
import jade.core.faultRecovery.PersistentStorage;
import jade.util.Logger;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

class FSPersistentStorage
implements PersistentStorage {
    public static final String LOCATION = "jade_core_faultRecovery_FSPersistentStorage_location";
    public static final String LOCATION_DEFAULT = ".";
    private static final String EXTENSION = ".fsps";
    private static final String CHILD_EXTENSION = ".fsps_c";
    private static final String UNREACHABLE_EXTENSION = ".unreachable";
    private static final String PLATFORM_FILE_NAME = "platform";
    private static final String NODE_POSTFIX = "-node";
    private String fileSeparator;
    private File locationDir;
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());

    FSPersistentStorage() {
    }

    public void init(Profile p) throws Exception {
        this.fileSeparator = System.getProperty("file.separator");
        String locationName = p.getParameter(LOCATION, LOCATION_DEFAULT);
        this.locationDir = new File(locationName);
        if (!this.locationDir.exists()) {
            this.myLogger.log(Logger.CONFIG, "FSPS location directory " + locationName + " does not exists. Creating it ...");
            boolean success = this.locationDir.mkdirs();
            if (!success) {
                throw new IOException("Cannot create FSPS location directory " + locationName + LOCATION_DEFAULT);
            }
        } else if (!this.locationDir.isDirectory()) {
            throw new IOException("FSPS location " + locationName + " is not a directory.");
        }
    }

    public void close() {
    }

    public void clear(final boolean clearPlatformInfo) throws Exception {
        File[] ff = this.locationDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (!clearPlatformInfo && name.equals("platform.fsps")) {
                    return false;
                }
                return name.endsWith(FSPersistentStorage.EXTENSION) || name.endsWith(FSPersistentStorage.CHILD_EXTENSION) || name.endsWith(FSPersistentStorage.UNREACHABLE_EXTENSION);
            }
        });
        for (int i = 0; i < ff.length; ++i) {
            ff[i].delete();
        }
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, "Removed " + ff.length + " files from persistent storage");
        }
    }

    public void storePlatformInfo(String platformName, String address) throws Exception {
        String tmp = platformName + '@' + address;
        File platformInfoFile = this.getFSPSFile(PLATFORM_FILE_NAME, EXTENSION);
        this.writeContent(platformInfoFile, tmp.getBytes());
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, "Platform information (name = " + platformName + ", address = " + address + " saved in persistent storage");
        }
    }

    public String[] getPlatformInfo() throws Exception {
        File addrFile = this.getFSPSFile(PLATFORM_FILE_NAME, EXTENSION);
        if (addrFile.exists()) {
            byte[] content = this.readContent(addrFile);
            String tmp = new String(content);
            int k = tmp.indexOf(64);
            if (k > 0) {
                String[] platformInfo = new String[]{tmp.substring(0, k), tmp.substring(k + 1)};
                return platformInfo;
            }
            return null;
        }
        return null;
    }

    public void storeNode(String name, boolean isChild, byte[] nn) throws Exception {
        File uf;
        File f = this.getFSPSFile(name + NODE_POSTFIX, isChild ? CHILD_EXTENSION : EXTENSION);
        this.writeContent(f, nn);
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, "Node " + name + " saved in persistent storage");
        }
        if ((uf = this.getUnreachableFile(f)).exists()) {
            uf.delete();
        }
    }

    public void removeNode(String name) throws Exception {
        File f = this.getFSPSFile(name + NODE_POSTFIX, EXTENSION);
        if (!f.exists()) {
            f = this.getFSPSFile(name + NODE_POSTFIX, CHILD_EXTENSION);
        }
        if (f.exists()) {
            f.delete();
            if (this.myLogger.isLoggable(Logger.FINE)) {
                this.myLogger.log(Logger.FINE, "Node " + name + " removed from persistent storage");
            }
        }
    }

    public void setUnreachable(String name) throws Exception {
        File f = this.getFSPSFile(name + NODE_POSTFIX, EXTENSION);
        if (!f.exists()) {
            f = this.getFSPSFile(name + NODE_POSTFIX, CHILD_EXTENSION);
        }
        if (f.exists()) {
            f.renameTo(this.getUnreachableFile(f));
            if (this.myLogger.isLoggable(Logger.FINE)) {
                this.myLogger.log(Logger.FINE, "Node " + name + " marked as unreachable");
            }
        }
    }

    public void resetUnreachable(String name) throws Exception {
        File f = this.getFSPSFile(name + NODE_POSTFIX, ".fsps.unreachable");
        if (!f.exists()) {
            f = this.getFSPSFile(name + NODE_POSTFIX, ".fsps_c.unreachable");
        }
        if (f.exists()) {
            f.renameTo(this.getReachableFile(f));
            if (this.myLogger.isLoggable(Logger.FINE)) {
                this.myLogger.log(Logger.FINE, "Node " + name + " restored as reachable");
            }
        }
    }

    public Map getAllNodes(boolean children) throws Exception {
        final String end2 = NODE_POSTFIX + (children ? CHILD_EXTENSION : EXTENSION);
        File[] ff = this.locationDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(end2);
            }
        });
        HashMap<String, byte[]> nodes = new HashMap<String, byte[]>(ff.length);
        for (int i = 0; i < ff.length; ++i) {
            nodes.put(this.getNodeName(ff[i].getName()), this.readContent(ff[i]));
        }
        return nodes;
    }

    public byte[] getUnreachableNode(String name) throws Exception {
        File f = this.getFSPSFile(name + NODE_POSTFIX, ".fsps.unreachable");
        if (!f.exists()) {
            f = this.getFSPSFile(name + NODE_POSTFIX, ".fsps_c.unreachable");
        }
        if (f.exists()) {
            return this.readContent(f);
        }
        return null;
    }

    private String getNodeName(String filename) {
        int index = filename.indexOf(EXTENSION);
        int length = index - 5;
        return filename.substring(0, length);
    }

    private File getFSPSFile(String name, String ext) {
        String fileName = this.locationDir.getPath() + this.fileSeparator + name + ext;
        return new File(fileName);
    }

    private File getUnreachableFile(File f) {
        String unreachableName = this.locationDir.getPath() + this.fileSeparator + f.getName() + UNREACHABLE_EXTENSION;
        return new File(unreachableName);
    }

    private File getReachableFile(File f) {
        int length = f.getName().length() - 12;
        String reachableName = this.locationDir.getPath() + this.fileSeparator + f.getName().substring(0, length);
        return new File(reachableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeContent(File file, byte[] content) throws Exception {
        file.createNewFile();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            fos.write(content);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readContent(File file) throws IOException {
        FileInputStream fis = null;
        int length = (int)file.length();
        if (length > 0) {
            byte[] content = new byte[length];
            try {
                int n;
                fis = new FileInputStream(file);
                int cnt = 0;
                do {
                    if ((n = fis.read(content, cnt, length - cnt)) != -1) continue;
                    throw new EOFException("EOF reading packet data");
                } while ((cnt += n) < length);
                byte[] byArray = content;
                return byArray;
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
            }
        }
        return null;
    }
}

