/*
 * Decompiled with CFR 0.152.
 */
package jade.domain.KBManagement;

import jade.core.AID;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.NotUnderstoodException;
import jade.domain.KBManagement.KB;
import jade.domain.KBManagement.KBIterator;
import jade.proto.SubscriptionResponder;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.List;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public abstract class DBKB
extends KB {
    protected String driver = "sun.jdbc.odbc.JdbcOdbcDriver";
    private ThreadLocal connections = new ThreadLocal();
    private String url;
    private String username;
    private String password;
    protected boolean cleanTables;

    public DBKB(String url, int maxResultLimit, boolean cleanTables) throws SQLException {
        this(null, url, maxResultLimit, cleanTables);
    }

    public DBKB(String drv, String url, int maxResultLimit, boolean cleanTables) throws SQLException {
        this(drv, url, null, null, maxResultLimit, cleanTables);
    }

    public DBKB(String drv, String url, String username, String password, int maxResultLimit, boolean cleanTables) throws SQLException {
        super(maxResultLimit);
        this.cleanTables = cleanTables;
        this.loadDBDriver(drv);
        this.url = url;
        this.username = username;
        this.password = password;
        Connection conn = this.getConnectionWrapper().getConnection();
        DatabaseMetaData md = conn.getMetaData();
        String dbName = md.getDatabaseProductName();
        if (dbName.toLowerCase().indexOf("sql server") != -1 && url.toLowerCase().indexOf("selectmethod") == -1) {
            if (!url.endsWith(";")) {
                url = url + ";";
            }
            this.url = url = url + "SelectMethod=cursor";
            this.invalidateConnectionWrapper();
        }
    }

    public abstract void setup() throws SQLException;

    private void loadDBDriver(String drv) throws SQLException {
        try {
            if (drv != null && !drv.equals("null")) {
                this.driver = drv;
            }
            Class.forName(this.driver).newInstance();
        }
        catch (Exception e) {
            throw new SQLException("Error loading driver " + this.driver + ". " + e);
        }
    }

    protected Connection createDBConnection(String url, String username, String password) throws SQLException {
        if (username != null) {
            return DriverManager.getConnection(url, username, password);
        }
        return DriverManager.getConnection(url);
    }

    protected final ConnectionWrapper getConnectionWrapper() throws SQLException {
        ConnectionWrapper wrapper = (ConnectionWrapper)this.connections.get();
        if (wrapper == null) {
            Connection conn = this.createDBConnection(this.url, this.username, this.password);
            wrapper = new ConnectionWrapper(conn);
            this.initConnectionWrapper(wrapper);
            this.connections.set(wrapper);
        }
        return wrapper;
    }

    protected void initConnectionWrapper(ConnectionWrapper wrapper) throws SQLException {
    }

    private void invalidateConnectionWrapper() throws SQLException {
        ConnectionWrapper wrapper = (ConnectionWrapper)this.connections.get();
        if (wrapper != null) {
            try {
                wrapper.getConnection().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.connections.set(null);
        }
    }

    protected Object insert(Object name, Object fact) {
        try {
            return this.insertSingle(name, fact);
        }
        catch (SQLException sqle) {
            try {
                this.logger.log(Logger.WARNING, "Invalidating DB connection...");
                this.invalidateConnectionWrapper();
                return this.insertSingle(name, fact);
            }
            catch (Exception e) {
                this.logger.log(Logger.SEVERE, "DB error inserting DFD for agent " + ((DFAgentDescription)fact).getName().getName(), sqle);
                try {
                    this.invalidateConnectionWrapper();
                }
                catch (Exception e1) {
                    // empty catch block
                }
                return null;
            }
        }
    }

    protected abstract Object insertSingle(Object var1, Object var2) throws SQLException;

    protected Object remove(Object name) {
        try {
            return this.removeSingle(name);
        }
        catch (SQLException sqle) {
            try {
                this.logger.log(Logger.WARNING, "Invalidating DB connection...");
                this.invalidateConnectionWrapper();
                return this.removeSingle(name);
            }
            catch (Exception e) {
                this.logger.log(Logger.SEVERE, "DB error removing DFD for agent " + ((AID)name).getName(), sqle);
                try {
                    this.invalidateConnectionWrapper();
                }
                catch (Exception e1) {
                    // empty catch block
                }
                return null;
            }
        }
    }

    protected abstract Object removeSingle(Object var1) throws SQLException;

    public List search(Object template, int maxResult) {
        try {
            return this.searchSingle(template, maxResult);
        }
        catch (SQLException sqle) {
            try {
                this.logger.log(Logger.WARNING, "Invalidating DB connection...");
                this.invalidateConnectionWrapper();
                return this.searchSingle(template, maxResult);
            }
            catch (Exception e) {
                this.logger.log(Logger.SEVERE, "DB error during search operation.", sqle);
                try {
                    this.invalidateConnectionWrapper();
                }
                catch (Exception e1) {
                    // empty catch block
                }
                return new ArrayList();
            }
        }
    }

    protected abstract List searchSingle(Object var1, int var2) throws SQLException;

    public KBIterator iterator(Object template) {
        try {
            return this.iteratorSingle(template);
        }
        catch (SQLException sqle) {
            try {
                this.logger.log(Logger.WARNING, "Invalidating DB connection...");
                this.invalidateConnectionWrapper();
                return this.iteratorSingle(template);
            }
            catch (Exception e) {
                this.logger.log(Logger.SEVERE, "DB error during iterated search operation.", sqle);
                try {
                    this.invalidateConnectionWrapper();
                }
                catch (Exception e1) {
                    // empty catch block
                }
                return new EmptyKBIterator();
            }
        }
    }

    protected abstract KBIterator iteratorSingle(Object var1) throws SQLException;

    public void subscribe(Object template, SubscriptionResponder.Subscription s) throws NotUnderstoodException {
        try {
            this.subscribeSingle(template, s);
        }
        catch (SQLException sqle) {
            try {
                this.logger.log(Logger.WARNING, "Invalidating DB connection...");
                this.invalidateConnectionWrapper();
                this.subscribeSingle(template, s);
            }
            catch (Exception e) {
                this.logger.log(Logger.SEVERE, "DB error during iterated search operation.", sqle);
                try {
                    this.invalidateConnectionWrapper();
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
        }
    }

    protected abstract void subscribeSingle(Object var1, SubscriptionResponder.Subscription var2) throws SQLException, NotUnderstoodException;

    public abstract Enumeration getSubscriptions();

    public void unsubscribe(SubscriptionResponder.Subscription s) {
        try {
            this.unsubscribeSingle(s);
        }
        catch (SQLException sqle) {
            try {
                this.logger.log(Logger.WARNING, "Invalidating DB connection...");
                this.invalidateConnectionWrapper();
                this.unsubscribeSingle(s);
            }
            catch (Exception e) {
                this.logger.log(Logger.SEVERE, "DB error during iterated search operation.", sqle);
                try {
                    this.invalidateConnectionWrapper();
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
        }
    }

    protected abstract void unsubscribeSingle(SubscriptionResponder.Subscription var1) throws SQLException;

    protected class EmptyKBIterator
    implements KBIterator {
        protected EmptyKBIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException("");
        }

        public void remove() {
        }

        public void close() {
        }
    }

    protected class ConnectionWrapper {
        private Connection conn;
        private Object info;

        public ConnectionWrapper(Connection conn) {
            this.conn = conn;
        }

        public Connection getConnection() {
            return this.conn;
        }

        public void setConnection(Connection conn) {
            this.conn = conn;
        }

        public Object getInfo() {
            return this.info;
        }

        public void setInfo(Object info) {
            this.info = info;
        }
    }
}

