/*
 * Decompiled with CFR 0.152.
 */
package jade.domain.introspection;

import jade.content.lang.sl.SLCodec;
import jade.core.AID;
import jade.core.behaviours.SimpleBehaviour;
import jade.domain.introspection.Event;
import jade.domain.introspection.EventRecord;
import jade.domain.introspection.IntrospectionOntology;
import jade.domain.introspection.Occurred;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.util.leap.Serializable;
import java.util.Map;
import java.util.TreeMap;

public abstract class AMSSubscriber
extends SimpleBehaviour {
    public static final String AMS_SUBSCRIPTION = "tool-subscription";
    public static final String AMS_CANCELLATION = "tool-cancellation";
    public static final String PLATFORM_EVENTS = "platform-events";
    private AID ams = null;
    private ACLMessage AMSSubscription = new ACLMessage(19);
    private ACLMessage AMSCancellation = new ACLMessage(2);
    private MessageTemplate listenTemplate;
    private boolean active = true;
    private Map handlers = new TreeMap(String.CASE_INSENSITIVE_ORDER);

    public AMSSubscriber() {
        MessageTemplate mt1 = MessageTemplate.MatchLanguage("fipa-sl0");
        MessageTemplate mt2 = MessageTemplate.MatchOntology("JADE-Introspection");
        MessageTemplate mt12 = MessageTemplate.and(mt1, mt2);
        mt1 = MessageTemplate.MatchInReplyTo(AMS_SUBSCRIPTION);
        mt2 = MessageTemplate.MatchPerformative(7);
        this.listenTemplate = MessageTemplate.and(mt1, mt2);
        this.listenTemplate = MessageTemplate.and(this.listenTemplate, mt12);
        this.installHandlers(this.handlers);
    }

    public AMSSubscriber(AID ams2) {
        this();
        this.ams = ams2;
    }

    public void onStart() {
        if (this.ams == null) {
            this.ams = this.myAgent.getAMS();
        }
        this.myAgent.getContentManager().registerOntology(IntrospectionOntology.getInstance());
        this.myAgent.getContentManager().registerLanguage(new SLCodec(), "fipa-sl0");
        this.AMSSubscription.addReceiver(this.ams);
        this.AMSSubscription.setLanguage("fipa-sl0");
        this.AMSSubscription.setOntology("JADE-Introspection");
        this.AMSSubscription.setReplyWith(AMS_SUBSCRIPTION);
        this.AMSSubscription.setConversationId(this.myAgent.getLocalName());
        this.AMSSubscription.setContent(PLATFORM_EVENTS);
        this.AMSCancellation.addReceiver(this.ams);
        this.AMSCancellation.setLanguage("fipa-sl0");
        this.AMSCancellation.setOntology("JADE-Introspection");
        this.AMSCancellation.setReplyWith(AMS_CANCELLATION);
        this.AMSCancellation.setConversationId(this.myAgent.getLocalName());
        this.myAgent.send(this.AMSSubscription);
    }

    protected abstract void installHandlers(Map var1);

    public final void action() {
        if (this.active) {
            ACLMessage current = this.myAgent.receive(this.listenTemplate);
            if (current != null) {
                try {
                    Occurred o = (Occurred)this.myAgent.getContentManager().extractContent(current);
                    EventRecord er = o.getWhat();
                    Event ev = er.getWhat();
                    String eventName = ev.getName();
                    EventHandler h = (EventHandler)this.handlers.get(eventName);
                    if (h != null) {
                        h.handle(ev);
                    }
                }
                catch (ClassCastException cce) {
                    cce.printStackTrace();
                }
                catch (Exception fe) {
                    fe.printStackTrace();
                }
            } else {
                this.block();
            }
        }
    }

    public final boolean done() {
        return !this.active;
    }

    public void cancel() {
        this.myAgent.send(this.getCancel());
        this.active = false;
        this.restart();
    }

    public final ACLMessage getSubscribe() {
        return this.AMSSubscription;
    }

    public final ACLMessage getCancel() {
        return this.AMSCancellation;
    }

    public static interface EventHandler
    extends Serializable {
        public void handle(Event var1);
    }
}

