/*
 * Decompiled with CFR 0.152.
 */
package jade.domain.persistence;

import jade.content.onto.BCReflectiveIntrospector;
import jade.content.onto.Introspector;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.schema.AgentActionSchema;
import jade.content.schema.ConceptSchema;
import jade.content.schema.PrimitiveSchema;
import jade.core.ContainerID;
import jade.domain.FIPAAgentManagement.ExceptionOntology;
import jade.domain.persistence.AgentGroup;
import jade.domain.persistence.DeleteAgent;
import jade.domain.persistence.DeleteAgentGroup;
import jade.domain.persistence.DeleteContainer;
import jade.domain.persistence.FreezeAgent;
import jade.domain.persistence.LoadAgent;
import jade.domain.persistence.LoadAgentGroup;
import jade.domain.persistence.LoadContainer;
import jade.domain.persistence.PersistenceVocabulary;
import jade.domain.persistence.ReloadAgent;
import jade.domain.persistence.SaveAgent;
import jade.domain.persistence.SaveAgentGroup;
import jade.domain.persistence.SaveContainer;
import jade.domain.persistence.ThawAgent;

public class PersistenceOntology
extends Ontology
implements PersistenceVocabulary {
    private static Ontology theInstance = new PersistenceOntology();

    public static Ontology getInstance() {
        return theInstance;
    }

    private PersistenceOntology() {
        super("JADE-Persistence", ExceptionOntology.getInstance(), (Introspector)new BCReflectiveIntrospector());
        try {
            this.add(new ConceptSchema("agent-group"), AgentGroup.class);
            this.add(new ConceptSchema("location"));
            this.add(new ConceptSchema("container-ID"), ContainerID.class);
            this.add(new AgentActionSchema("load-agent"), LoadAgent.class);
            this.add(new AgentActionSchema("reload-agent"), ReloadAgent.class);
            this.add(new AgentActionSchema("save-agent"), SaveAgent.class);
            this.add(new AgentActionSchema("delete-agent"), DeleteAgent.class);
            this.add(new AgentActionSchema("freeze-agent"), FreezeAgent.class);
            this.add(new AgentActionSchema("thaw-agent"), ThawAgent.class);
            this.add(new AgentActionSchema("save-container"), SaveContainer.class);
            this.add(new AgentActionSchema("load-container"), LoadContainer.class);
            this.add(new AgentActionSchema("delete-container"), DeleteContainer.class);
            this.add(new AgentActionSchema("load-agent-group"), LoadAgentGroup.class);
            this.add(new AgentActionSchema("save-agent-group"), SaveAgentGroup.class);
            this.add(new AgentActionSchema("delete-agent-group"), DeleteAgentGroup.class);
            ConceptSchema cs = (ConceptSchema)this.getSchema("location");
            cs.add("name", (PrimitiveSchema)this.getSchema("BO_String"));
            cs.add("protocol", (PrimitiveSchema)this.getSchema("BO_String"), 1);
            cs.add("address", (PrimitiveSchema)this.getSchema("BO_String"), 1);
            cs = (ConceptSchema)this.getSchema("container-ID");
            cs.addSuperSchema((ConceptSchema)this.getSchema("location"));
            AgentActionSchema as = (AgentActionSchema)this.getSchema("save-agent");
            as.add("agent", (ConceptSchema)this.getSchema("agent-identifier"));
            as.add("repository", (PrimitiveSchema)this.getSchema("BO_String"));
            as = (AgentActionSchema)this.getSchema("load-agent");
            as.add("agent", (ConceptSchema)this.getSchema("agent-identifier"));
            as.add("repository", (PrimitiveSchema)this.getSchema("BO_String"));
            as.add("where", (ConceptSchema)this.getSchema("container-ID"));
            as = (AgentActionSchema)this.getSchema("reload-agent");
            as.add("agent", (ConceptSchema)this.getSchema("agent-identifier"));
            as.add("repository", (PrimitiveSchema)this.getSchema("BO_String"));
            as = (AgentActionSchema)this.getSchema("delete-agent");
            as.add("agent", (ConceptSchema)this.getSchema("agent-identifier"));
            as.add("repository", (PrimitiveSchema)this.getSchema("BO_String"));
            as.add("where", (ConceptSchema)this.getSchema("container-ID"));
            as = (AgentActionSchema)this.getSchema("freeze-agent");
            as.add("agent", (ConceptSchema)this.getSchema("agent-identifier"));
            as.add("repository", (PrimitiveSchema)this.getSchema("BO_String"));
            as.add("buffer-container", (ConceptSchema)this.getSchema("container-ID"), 1);
            as = (AgentActionSchema)this.getSchema("thaw-agent");
            as.add("agent", (ConceptSchema)this.getSchema("agent-identifier"));
            as.add("repository", (PrimitiveSchema)this.getSchema("BO_String"));
            as.add("new-container", (ConceptSchema)this.getSchema("container-ID"), 1);
            as = (AgentActionSchema)this.getSchema("save-container");
            as.add("container", (ConceptSchema)this.getSchema("container-ID"));
            as.add("repository", (PrimitiveSchema)this.getSchema("BO_String"));
            as = (AgentActionSchema)this.getSchema("load-container");
            as.add("container", (ConceptSchema)this.getSchema("container-ID"));
            as.add("repository", (PrimitiveSchema)this.getSchema("BO_String"));
            as = (AgentActionSchema)this.getSchema("delete-container");
            as.add("container", (ConceptSchema)this.getSchema("container-ID"));
            as.add("repository", (PrimitiveSchema)this.getSchema("BO_String"));
            as.add("where", (ConceptSchema)this.getSchema("container-ID"));
            as = (AgentActionSchema)this.getSchema("save-agent-group");
            as.add("group", (ConceptSchema)this.getSchema("agent-group"));
            as.add("repository", (PrimitiveSchema)this.getSchema("BO_String"));
            as = (AgentActionSchema)this.getSchema("delete-agent-group");
            as.add("group", (ConceptSchema)this.getSchema("agent-group"));
            as.add("repository", (PrimitiveSchema)this.getSchema("BO_String"));
            as = (AgentActionSchema)this.getSchema("load-agent-group");
            as.add("group", (ConceptSchema)this.getSchema("agent-group"));
            as.add("repository", (PrimitiveSchema)this.getSchema("BO_String"));
        }
        catch (OntologyException oe) {
            oe.printStackTrace();
        }
    }
}

