/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.JICP;

import jade.imtp.leap.ICPException;
import jade.imtp.leap.JICP.Connection;
import jade.imtp.leap.JICP.ConnectionFactory;
import jade.imtp.leap.JICP.ConnectionWrapper;
import jade.imtp.leap.TransportProtocol;
import jade.imtp.leap.http.HTTPProtocol;
import jade.mtp.TransportAddress;
import jade.util.leap.ArrayList;
import jade.util.leap.HashMap;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import java.io.IOException;

class ConnectionPool {
    private HashMap connections = new HashMap();
    private TransportProtocol myProtocol;
    private ConnectionFactory myFactory;
    private int maxSize;
    private int size;
    private boolean closed = false;
    private long hitCnt = 0L;
    private long missCnt = 0L;

    ConnectionPool(TransportProtocol p, ConnectionFactory f, int ms) {
        this.myProtocol = p;
        this.myFactory = f;
        this.maxSize = this.myProtocol instanceof HTTPProtocol ? 0 : ms;
        this.size = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConnectionWrapper acquire(TransportAddress ta, boolean requireFreshConnection) throws ICPException {
        ConnectionWrapper cw = null;
        List l = null;
        String url = this.myProtocol.addrToString(ta);
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            if (this.closed) {
                throw new ICPException("Pool closed");
            }
            l = (List)this.connections.get(url);
            if (l == null) {
                l = new ArrayList();
                this.connections.put(url, l);
            }
            if (requireFreshConnection) {
                this.closeConnections(l);
            } else {
                Iterator it = l.iterator();
                while (it.hasNext()) {
                    cw = (ConnectionWrapper)it.next();
                    if (!cw.lock()) continue;
                    cw.setReused();
                    ++this.hitCnt;
                    return cw;
                }
            }
        }
        try {
            Connection c = this.myFactory.createConnection(ta);
            ConnectionPool connectionPool2 = this;
            synchronized (connectionPool2) {
                try {
                    cw = new ConnectionWrapper(c, ta);
                    if (this.size < this.maxSize) {
                        l.add(cw);
                        ++this.size;
                    } else {
                        cw.setOneShot();
                    }
                    ++this.missCnt;
                    ConnectionWrapper connectionWrapper = cw;
                    return connectionWrapper;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        throw new ICPException("Error creating connection. ", ioe);
                    }
                }
            }
        }
        finally {
            ConnectionPool connectionPool3 = this;
            synchronized (connectionPool3) {
                if (l.isEmpty()) {
                    this.connections.remove(url);
                }
            }
        }
    }

    private void closeConnections(List l) {
        ArrayList closedConnections = new ArrayList();
        Iterator it = l.iterator();
        while (it.hasNext()) {
            ConnectionWrapper cw = (ConnectionWrapper)it.next();
            if (!cw.lock()) continue;
            cw.close();
            cw.unlock();
            closedConnections.add(cw);
        }
        it = closedConnections.iterator();
        while (it.hasNext()) {
            if (!l.remove(it.next())) continue;
            --this.size;
        }
    }

    synchronized void release(ConnectionWrapper cw) {
        cw.unlock();
    }

    synchronized void remove(ConnectionWrapper cw) {
        try {
            String url = this.myProtocol.addrToString(cw.getDestAddress());
            List l = (List)this.connections.get(url);
            if (l != null && l.remove(cw)) {
                --this.size;
                if (l.isEmpty()) {
                    this.connections.remove(url);
                }
            }
            cw.getConnection().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    synchronized void shutdown() {
        Iterator it = this.connections.values().iterator();
        while (it.hasNext()) {
            List l = (List)it.next();
            for (int i = 0; i < l.size(); ++i) {
                ConnectionWrapper cw = (ConnectionWrapper)l.get(i);
                cw.close();
            }
            l.clear();
        }
        this.connections.clear();
        this.closed = true;
    }

    void clearExpiredConnections(long currentTime) {
        Iterator it = this.getConnectionsList().iterator();
        while (it.hasNext()) {
            ConnectionWrapper cw = (ConnectionWrapper)it.next();
            if (!cw.isExpired(currentTime)) continue;
            this.remove(cw);
            cw.unlock();
        }
    }

    public String toString() {
        return "[Connection-pool: total-hit=" + this.hitCnt + ", total-miss=" + this.missCnt + ", current-size=" + this.size + " connections=" + this.connections + "]";
    }

    private synchronized List getConnectionsList() {
        ArrayList cc = new ArrayList();
        Iterator it = this.connections.values().iterator();
        while (it.hasNext()) {
            List l = (List)it.next();
            Iterator it1 = l.iterator();
            while (it1.hasNext()) {
                cc.add(it1.next());
            }
        }
        return cc;
    }
}

